/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Card;
import core.GameException;
import core.GameState;
import core.Player;
import core.cards.DistanceCard;
import core.cards.Hazard;
import core.cards.HazardCard;
import core.cards.Remedy;
import core.cards.RemedyCard;
import core.cards.Safety;
import core.cards.SafetyCard;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Observable;
import javax.swing.JOptionPane;
import ui.DrawWindow;
import ui.MainMenu;
import ui.MainWindow;

public class Game
extends Observable
implements Serializable {
    private static final long serialVersionUID = 8589660817464027551L;
    private GameState state = GameState.CREATION;
    private int currentPlayer;
    private boolean ignore;
    private ArrayList<Player> players = new ArrayList();
    private LinkedList<Card> drawPile = new LinkedList();
    private LinkedList<Card> discardPile = new LinkedList();

    public void addPlayer(Player player) throws GameException {
        if (this.state != GameState.CREATION) {
            throw new GameException("You can't add a player once the game has started");
        }
        if (this.players.size() >= 6) {
            throw new GameException("You can't play a game with more than 6 players");
        }
        this.players.add(player);
        this.updateUI();
    }

    public void removePlayer(Player player) throws GameException {
        if (this.state != GameState.CREATION) {
            throw new GameException("You can't remove a player once the game has started");
        }
        if (!this.players.contains(player)) {
            throw new GameException("Game doesn't own this player");
        }
        this.players.remove(player);
        this.updateUI();
    }

    public void start() throws GameException {
        boolean hasHuman = false;
        for (Player p : this.players) {
            if (!p.isHuman()) continue;
            hasHuman = true;
            break;
        }
        if (!hasHuman) {
            throw new GameException("You need a human to play");
        }
        if (this.state != GameState.CREATION) {
            throw new GameException("Game has already started");
        }
        this.state = GameState.STARTED;
        this.initPiles();
        this.shufflePlayers();
        this.shuffleCards();
        this.dealCards();
    }

    private void initPiles() {
        this.drawPile.clear();
        this.discardPile.clear();
        this.drawPile.add(new SafetyCard(Safety.DRIVING_ACE));
        this.drawPile.add(new SafetyCard(Safety.EXTRA_TANK));
        this.drawPile.add(new SafetyCard(Safety.PUNCTURE_PROOF));
        this.drawPile.add(new SafetyCard(Safety.RIGHT_OF_WAY));
        int i = 0;
        while (i < 2) {
            this.drawPile.add(new HazardCard(Hazard.ACCIDENT));
            this.drawPile.add(new HazardCard(Hazard.FLAT_TIRE));
            this.drawPile.add(new HazardCard(Hazard.OUT_OF_GAS));
            this.drawPile.add(new HazardCard(Hazard.SPEED_LIMIT));
            this.drawPile.add(new HazardCard(Hazard.STOP));
            ++i;
        }
        i = 0;
        while (i < 3) {
            this.drawPile.add(new DistanceCard(200));
            ++i;
        }
        i = 0;
        while (i < 4) {
            this.drawPile.add(new RemedyCard(Remedy.END_OF_LIMIT));
            this.drawPile.add(new RemedyCard(Remedy.GASOLINE));
            this.drawPile.add(new RemedyCard(Remedy.REPAIR));
            this.drawPile.add(new RemedyCard(Remedy.SPARE_TIRE));
            ++i;
        }
        i = 0;
        while (i < 5) {
            this.drawPile.add(new RemedyCard(Remedy.ROLL));
            ++i;
        }
        i = 0;
        while (i < 6) {
            this.drawPile.add(new DistanceCard(25));
            this.drawPile.add(new DistanceCard(50));
            this.drawPile.add(new DistanceCard(75));
            ++i;
        }
        i = 0;
        while (i < 9) {
            this.drawPile.add(new DistanceCard(100));
            ++i;
        }
    }

    private void shufflePlayers() {
        Collections.shuffle(this.players);
    }

    private void shuffleCards() {
        Collections.shuffle(this.drawPile);
    }

    private void dealCards() {
        for (Player player : this.players) {
            int i = 0;
            while (i < 4) {
                player.getHand().add(this.drawPile.pop());
                ++i;
            }
        }
    }

    public void updateUI() {
        if (this.getCurrentPlayer().isHuman()) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void nextTurn() {
        if (this.state == GameState.FINNISHED) {
            return;
        }
        Player winner = this.getWinner();
        if (winner != null || this.isFinished()) {
            this.state = GameState.FINNISHED;
            this.updateUI();
            if (winner == null) {
                JOptionPane.showMessageDialog(null, "There is no more distance card. Game is over");
            } else {
                JOptionPane.showMessageDialog(null, String.valueOf(winner.getName()) + " wins the game !");
            }
            MainWindow.getInstance().switchTo(new MainMenu());
            return;
        }
        if (this.ignore) {
            this.ignore = false;
            this.updateUI();
            if (this.getCurrentPlayer().isHuman()) {
                JOptionPane.showMessageDialog(null, "You can play again");
            }
        } else {
            this.currentPlayer = (this.currentPlayer + 1) % this.players.size();
        }
        this.updateUI();
        Player p = this.getCurrentPlayer();
        if (!this.drawPile.isEmpty() || !this.discardPile.isEmpty()) {
            if (p.isHuman()) {
                new DrawWindow(p, this.drawPile, this.discardPile).setVisible(true);
            } else if (this.discardPile.isEmpty()) {
                p.getHand().add(this.drawPile.pop());
            } else {
                Boolean draw = p.drawDiscard(this.discardPile.get(0));
                if (draw.booleanValue() && !this.discardPile.isEmpty()) {
                    p.getHand().add(this.discardPile.pop());
                } else if (!this.drawPile.isEmpty()) {
                    p.getHand().add(this.drawPile.pop());
                } else if (!this.discardPile.isEmpty()) {
                    p.getHand().add(this.discardPile.pop());
                }
            }
        }
        if (!p.isHuman()) {
            if (!p.play(this).booleanValue()) {
                p.discardCard(p.getCardToDiscard());
            }
            try {
                this.nextTurn();
            }
            catch (StackOverflowError err) {
                JOptionPane.showMessageDialog(null, "No winner (StackOverFlowed by bots)");
                System.exit(0);
            }
        }
        this.updateUI();
    }

    public Player[] getPotentialTargets(HazardCard card) {
        ArrayList<Player> targets = new ArrayList<Player>();
        for (Player p : this.players) {
            if (card.getExceptionMessage(this, p) != null) continue;
            targets.add(p);
        }
        Collections.sort(targets);
        return targets.toArray(new Player[targets.size()]);
    }

    private Player getWinner() {
        for (Player p : this.players) {
            if (p.getTotalDistance() < 1000) continue;
            return p;
        }
        return null;
    }

    private boolean isFinished() {
        for (Card card : this.drawPile) {
            if (!(card instanceof DistanceCard)) continue;
            return false;
        }
        for (Card card : this.discardPile) {
            if (!(card instanceof DistanceCard)) continue;
            return false;
        }
        for (Player p : this.players) {
            for (Card card : p.getHand()) {
                if (!(card instanceof DistanceCard)) continue;
                return false;
            }
        }
        return true;
    }

    public GameState getState() {
        return this.state;
    }

    public Player getCurrentPlayer() {
        return this.players.get(this.currentPlayer);
    }

    public int getNbPlayers() {
        return this.players.size();
    }

    public ArrayList<Player> getPlayers() {
        return this.players;
    }

    public LinkedList<Card> getDrawPile() {
        return this.drawPile;
    }

    public LinkedList<Card> getDiscardPile() {
        return this.discardPile;
    }

    public void playAgain() {
        this.ignore = true;
    }
}

