/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Card;
import core.Game;
import core.cards.DistanceCard;
import core.cards.Hazard;
import core.cards.HazardCard;
import core.cards.SafetyCard;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.JOptionPane;

public abstract class Player
extends Observable
implements Comparable<Player> {
    private ArrayList<Card> hand = new ArrayList();
    private ArrayList<DistanceCard> distances = new ArrayList();
    private ArrayList<SafetyCard> safeties = new ArrayList();
    private boolean roll;
    private Game game;
    private String name;
    private int avatarId;
    private int bonus;
    private HazardCard hazard;

    public Player(Game game, String name, int avatarId) {
        this.game = game;
        this.name = name;
        this.avatarId = avatarId;
    }

    public abstract Boolean play(Game var1);

    public abstract Boolean drawDiscard(Card var1);

    public abstract Card getCardToDiscard();

    public abstract boolean isHuman();

    public void addBonus(int km) {
        if (this.getTotalDistance() + km <= 1000) {
            this.bonus += km;
        }
    }

    public boolean isTurn() {
        return this.game.getCurrentPlayer() == this;
    }

    public void setRollable() {
        this.roll = true;
    }

    public boolean canRoll() {
        return this.roll;
    }

    public boolean isProtected(Hazard hazard) {
        for (SafetyCard s : this.safeties) {
            if (!s.getSafety().protect(hazard) || s.isHidden()) continue;
            return true;
        }
        return false;
    }

    public boolean testUnderHandTrick(HazardCard card) {
        for (SafetyCard s : this.safeties) {
            if (!s.getSafety().protect(card.getHazard()) || !s.isHidden()) continue;
            s.effect(this.game, this);
            this.update();
            JOptionPane.showMessageDialog(null, String.valueOf(this.name) + " does an underhand trick with " + s.toString().replace("_", " "));
            return true;
        }
        return false;
    }

    public boolean canMove(DistanceCard card) {
        if (this.hazard == null) {
            return this.roll;
        }
        if (this.hazard.getHazard() != Hazard.SPEED_LIMIT) {
            return false;
        }
        if (card == null) {
            return this.roll;
        }
        return this.roll && card.getDistance() <= 50;
    }

    public String getName() {
        return this.name;
    }

    public int getAvatarId() {
        return this.avatarId;
    }

    public HazardCard getHazard() {
        return this.hazard;
    }

    public ArrayList<Card> getHand() {
        return this.hand;
    }

    public ArrayList<SafetyCard> getSafeties() {
        return this.safeties;
    }

    public void playCard(Card card) {
        if (card instanceof DistanceCard) {
            this.distances.add((DistanceCard)card);
        } else if (card instanceof SafetyCard) {
            this.safeties.add((SafetyCard)card);
        }
        this.update();
    }

    public void discardCard(Card card) {
        this.hand.remove(card);
        this.game.getDiscardPile().add(0, card);
        this.update();
    }

    public int getTotalDistance() {
        int total = this.bonus;
        for (DistanceCard dc : this.distances) {
            total += dc.getDistance();
        }
        return total;
    }

    public void setHazard(HazardCard hazard) {
        this.hazard = hazard;
        this.update();
    }

    public void update() {
        this.setChanged();
        this.notifyObservers();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Player p) {
        return new Integer(p.getTotalDistance()).compareTo(this.getTotalDistance());
    }
}

