/*
 * Decompiled with CFR 0.152.
 */
package core.behaviors;

import core.Card;
import core.Game;
import core.GameException;
import core.Player;
import core.PlayerBehavior;
import core.cards.DistanceCard;
import core.cards.HazardCard;
import core.cards.Remedy;
import core.cards.RemedyCard;
import core.cards.SafetyCard;
import java.util.Collection;

public class StrongBehavior
implements PlayerBehavior {
    @Override
    public Boolean draw(Player player, Card discard) {
        if (!player.canRoll()) {
            if (!(discard instanceof RemedyCard && ((RemedyCard)discard).getRemedy() == Remedy.ROLL || discard instanceof SafetyCard)) {
                return false;
            }
            return true;
        }
        if (!(discard instanceof RemedyCard && player.getHazard() != null && player.getHazard().getHazard().repairedBy(((RemedyCard)discard).getRemedy()) || player.getHazard() == null && discard instanceof DistanceCard && this.good(player.getHand(), (DistanceCard)discard) || discard instanceof HazardCard && this.good(player.getHand(), (HazardCard)discard))) {
            return false;
        }
        return true;
    }

    @Override
    public Card getCardToDiscard(Collection<Card> hand, Player player) {
        Card card = null;
        for (Card c : hand) {
            if (card != null && this.better(c, card, player)) continue;
            card = c;
        }
        if (card == null) {
            throw new NullPointerException("bot can't do it");
        }
        return card;
    }

    @Override
    public Boolean play(Collection<Card> hand, Game game) {
        Player p = game.getCurrentPlayer();
        Card card = null;
        for (Card c : hand) {
            if (!p.canRoll() && c instanceof RemedyCard && ((RemedyCard)c).getRemedy() == Remedy.ROLL) {
                try {
                    c.playCard(game);
                    return true;
                }
                catch (GameException e) {
                    System.err.println("*BOT* -> erreur de jugement (i-s) : " + e);
                }
            }
            if (c instanceof SafetyCard) {
                try {
                    ((SafetyCard)c).setHidden(true);
                    c.playCard(game);
                    return true;
                }
                catch (GameException e) {
                    System.err.println("*BOT* -> erreur de jugement (0s) : " + e);
                }
            }
            if (p.canMove(null) && c instanceof DistanceCard && (card == null || ((DistanceCard)card).getDistance() < ((DistanceCard)c).getDistance()) && ((DistanceCard)c).getDistance() + p.getTotalDistance() <= 1000 && p.canMove((DistanceCard)c)) {
                card = c;
            }
            if (p.getHazard() != null && c instanceof RemedyCard && p.getHazard().getHazard().repairedBy(((RemedyCard)c).getRemedy())) {
                try {
                    c.playCard(game);
                    return true;
                }
                catch (GameException e) {
                    System.err.println("*BOT* -> erreur de jugement (1s) : " + e);
                }
            }
            if (c instanceof RemedyCard && ((RemedyCard)c).getRemedy() == Remedy.ROLL && !p.canRoll()) {
                try {
                    c.playCard(game);
                    return true;
                }
                catch (GameException e) {
                    System.err.println("*BOT* -> erreur de jugement (2s) : " + e);
                }
            }
            if (!(c instanceof HazardCard) || game.getPotentialTargets((HazardCard)c).length <= 0) continue;
            try {
                ((HazardCard)c).playCard(game, game.getPotentialTargets((HazardCard)c)[0]);
                return true;
            }
            catch (GameException e) {
                System.err.println("*BOT* -> erreur de jugement (3s) : " + e);
            }
        }
        if (card != null) {
            try {
                card.playCard(game);
                return true;
            }
            catch (GameException e) {
                System.err.println("*BOT* -> erreur de jugement (4s) : " + e);
            }
        }
        return false;
    }

    private boolean better(Card c, Card card, Player player) {
        return c instanceof SafetyCard || c instanceof RemedyCard && player.getHazard() != null && player.getHazard().getHazard().repairedBy(((RemedyCard)c).getRemedy()) || c instanceof DistanceCard && card instanceof DistanceCard && ((DistanceCard)c).getDistance() > ((DistanceCard)card).getDistance();
    }

    private boolean good(Collection<Card> hand, HazardCard discard) {
        for (Card c : hand) {
            if (!(c instanceof HazardCard) || ((HazardCard)c).getHazard() != discard.getHazard()) continue;
            return false;
        }
        return true;
    }

    private boolean good(Collection<Card> hand, DistanceCard discard) {
        if (discard.getDistance() >= 100) {
            return true;
        }
        int max = 0;
        for (Card c : hand) {
            if (!(c instanceof DistanceCard) || ((DistanceCard)c).getDistance() >= max) continue;
            max = ((DistanceCard)c).getDistance();
        }
        return discard.getDistance() > max;
    }
}

