/*
 * Decompiled with CFR 0.152.
 */
package core.behaviors;

import core.Card;
import core.Game;
import core.GameException;
import core.Player;
import core.PlayerBehavior;
import core.cards.DistanceCard;
import core.cards.HazardCard;
import core.cards.Remedy;
import core.cards.RemedyCard;
import core.cards.SafetyCard;
import java.util.Collection;

public class WeakBehavior
implements PlayerBehavior {
    @Override
    public Boolean draw(Player player, Card discard) {
        if (!player.canRoll()) {
            if (!(discard instanceof RemedyCard && ((RemedyCard)discard).getRemedy() == Remedy.ROLL || discard instanceof SafetyCard)) {
                return false;
            }
            return true;
        }
        if (!(discard instanceof RemedyCard && player.getHazard() != null && player.getHazard().getHazard().repairedBy(((RemedyCard)discard).getRemedy()) || discard instanceof DistanceCard)) {
            return false;
        }
        return true;
    }

    @Override
    public Card getCardToDiscard(Collection<Card> hand, Player player) {
        for (Card c : hand) {
            if (!(c instanceof HazardCard)) continue;
            return c;
        }
        Card card = null;
        for (Card c : hand) {
            if (card != null && !(c instanceof RemedyCard)) continue;
            card = c;
        }
        if (card == null) {
            throw new NullPointerException("bot can't do it");
        }
        return card;
    }

    @Override
    public Boolean play(Collection<Card> hand, Game game) {
        Player p = game.getCurrentPlayer();
        Card card = null;
        for (Card c : hand) {
            if (!p.canRoll() && c instanceof RemedyCard && ((RemedyCard)c).getRemedy() == Remedy.ROLL) {
                try {
                    c.playCard(game);
                    return true;
                }
                catch (GameException e) {
                    System.err.println("*BOT* -> erreur de jugement (i-w) : " + e);
                }
            }
            if (c instanceof SafetyCard) {
                try {
                    ((SafetyCard)c).setHidden(false);
                    c.playCard(game);
                    return true;
                }
                catch (GameException e) {
                    System.err.println("*BOT* -> erreur de jugement (0w) : " + e);
                }
            }
            if (p.canMove(null) && c instanceof DistanceCard && (card == null || ((DistanceCard)card).getDistance() < ((DistanceCard)c).getDistance()) && ((DistanceCard)c).getDistance() + p.getTotalDistance() <= 1000 && p.canMove((DistanceCard)c)) {
                card = c;
            }
            if (p.getHazard() != null && c instanceof RemedyCard && p.getHazard().getHazard().repairedBy(((RemedyCard)c).getRemedy())) {
                try {
                    c.playCard(game);
                    return true;
                }
                catch (GameException e) {
                    System.err.println("*BOT* -> erreur de jugement (1w) : " + e);
                }
            }
            if (!(c instanceof RemedyCard) || ((RemedyCard)c).getRemedy() != Remedy.ROLL || p.canRoll()) continue;
            try {
                c.playCard(game);
                return true;
            }
            catch (GameException e) {
                System.err.println("*BOT* -> erreur de jugement (2w) : " + e);
            }
        }
        if (card != null) {
            try {
                card.playCard(game);
                return true;
            }
            catch (GameException e) {
                System.err.println("*BOT* -> erreur de jugement (3w) : " + e);
            }
        }
        return false;
    }
}

