/*
 * Decompiled with CFR 0.152.
 */
package core.cards;

import core.Card;
import core.Game;
import core.GameException;

public class DistanceCard
extends Card {
    private int distance;

    public DistanceCard(int distance) {
        super("cards/distances/" + distance + ".jpg");
        this.distance = distance;
    }

    public int getDistance() {
        return this.distance;
    }

    public String toString() {
        return String.valueOf(this.distance);
    }

    @Override
    public void playCard(Game game) throws GameException {
        if (game.getCurrentPlayer().getTotalDistance() + this.distance > 1000) {
            throw new GameException("unable to exceed 1000km");
        }
        if (!game.getCurrentPlayer().canMove(this)) {
            throw new GameException("Unable to move");
        }
        super.playCard(game);
    }
}

