/*
 * Decompiled with CFR 0.152.
 */
package core.cards;

import core.Card;
import core.Game;
import core.GameException;
import core.Player;
import core.cards.Hazard;

public class HazardCard
extends Card {
    private Hazard hazard;

    public HazardCard(Hazard hazard) {
        super("cards/hazards/" + (Object)((Object)hazard) + ".jpg");
        this.hazard = hazard;
    }

    public void playCard(Game game, Player target) throws GameException {
        String message = this.getExceptionMessage(game, target);
        if (message != null) {
            throw new GameException(message);
        }
        if (!target.testUnderHandTrick(this)) {
            target.setHazard(this);
        }
        this.playCard(game);
    }

    public Hazard getHazard() {
        return this.hazard;
    }

    public String toString() {
        return this.hazard.toString().replace("_", " ");
    }

    public String getExceptionMessage(Game game, Player target) {
        if (target == null) {
            return "You need a target";
        }
        if (game.getCurrentPlayer() == target) {
            return "Can't target yourself";
        }
        if (target.getHazard() != null) {
            return String.valueOf(target.getName()) + " already has a hazard";
        }
        if (!target.canRoll() && this.hazard != Hazard.SPEED_LIMIT) {
            return (Object)((Object)this.hazard) + " cannot be applied to " + target.getName() + " because he hasn't started yet";
        }
        if (target.isProtected(this.hazard)) {
            return String.valueOf(target.getName()) + " is protected from " + (Object)((Object)this.hazard);
        }
        return null;
    }
}

