/*
 * Decompiled with CFR 0.152.
 */
package core.cards;

import core.Card;
import core.Game;
import core.GameException;
import core.Player;
import core.cards.Remedy;

public class RemedyCard
extends Card {
    private Remedy remedy;

    public RemedyCard(Remedy remedy) {
        super("cards/remedies/" + (Object)((Object)remedy) + ".jpg");
        this.remedy = remedy;
    }

    public Remedy getRemedy() {
        return this.remedy;
    }

    public String toString() {
        return String.valueOf((Object)this.remedy);
    }

    @Override
    public void playCard(Game game) throws GameException {
        Player p = game.getCurrentPlayer();
        if (this.remedy == Remedy.ROLL && !p.canRoll()) {
            p.setRollable();
        } else {
            if (p.getHazard() == null) {
                throw new GameException("Nothing can be repaired");
            }
            if (!p.getHazard().getHazard().repairedBy(this.remedy)) {
                throw new GameException(String.valueOf(p.getHazard().toString().replace("_", " ")) + " cannot be repaired by " + this.remedy.toString().replace(" ", " "));
            }
            game.getDiscardPile().add(0, p.getHazard());
            game.getDiscardPile().add(0, this);
            p.setHazard(null);
        }
        super.playCard(game);
    }
}

