/*
 * Decompiled with CFR 0.152.
 */
package core.cards;

import core.Card;
import core.Game;
import core.GameException;
import core.Player;
import core.cards.Safety;

public class SafetyCard
extends Card {
    private Safety safety;
    private boolean hidden;

    public SafetyCard(Safety safety) {
        super("cards/safeties/" + (Object)((Object)safety) + ".jpg");
        this.safety = safety;
    }

    public Safety getSafety() {
        return this.safety;
    }

    public String toString() {
        return String.valueOf((Object)this.safety);
    }

    public void effect(Game game, Player target) {
        if (this.hidden) {
            target.addBonus(300);
            this.setHidden(false);
            game.updateUI();
        } else {
            target.addBonus(100);
        }
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void playCard(Game game) throws GameException {
        if (this.safety == Safety.DRIVING_ACE && !this.hidden) {
            game.getCurrentPlayer().setRollable();
        }
        if (!this.hidden) {
            this.effect(game, game.getCurrentPlayer());
        }
        game.playAgain();
        super.playCard(game);
    }
}

