/*
 * Decompiled with CFR 0.152.
 */
package core.players;

import core.Card;
import core.Game;
import core.Player;
import core.PlayerBehavior;

public class AIPlayer
extends Player {
    private PlayerBehavior behavior;

    public AIPlayer(Game game, String name, int avatarId, PlayerBehavior behavior) {
        super(game, name, avatarId);
        this.behavior = behavior;
    }

    @Override
    public Boolean drawDiscard(Card discard) {
        return this.behavior.draw(this, discard);
    }

    @Override
    public Boolean play(Game game) {
        return this.behavior.play(game.getCurrentPlayer().getHand(), game);
    }

    @Override
    public Card getCardToDiscard() {
        return this.behavior.getCardToDiscard(this.getHand(), this);
    }

    @Override
    public boolean isHuman() {
        return false;
    }
}

