/*
 * Decompiled with CFR 0.152.
 */
package ui;

import core.Card;
import core.Game;
import core.GameException;
import core.Player;
import core.cards.HazardCard;
import core.cards.SafetyCard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class ChooseCardListener
implements ActionListener {
    private static final String[] OPTIONS = new String[]{"put this card", "discard this card"};
    private Game game;
    private Card card;

    public ChooseCardListener(Game game, Card card) {
        this.game = game;
        this.card = card;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String selection = (String)JOptionPane.showInputDialog(null, "Select action", "Action selection", -1, new ImageIcon(this.card.getIcon()), OPTIONS, OPTIONS[0]);
        if (selection == null) {
            return;
        }
        if (selection == OPTIONS[1]) {
            this.game.getCurrentPlayer().discardCard(this.card);
            this.game.nextTurn();
        } else if (selection == OPTIONS[0]) {
            try {
                if (this.card instanceof HazardCard) {
                    Player target = (Player)JOptionPane.showInputDialog(null, "Select target", "Target selection", -1, null, this.game.getPotentialTargets((HazardCard)this.card), null);
                    if (target == null) {
                        return;
                    }
                    ((HazardCard)this.card).playCard(this.game, target);
                } else if (this.card instanceof SafetyCard) {
                    ((SafetyCard)this.card).setHidden(JOptionPane.showConfirmDialog(null, "Hide the card ?", "Safety Card", 0) == 0);
                    this.card.playCard(this.game);
                } else {
                    this.card.playCard(this.game);
                }
                this.game.nextTurn();
            }
            catch (GameException ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 2);
            }
        }
    }
}

