/*
 * Decompiled with CFR 0.152.
 */
package ui;

import core.Game;
import core.GameException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ui.CreatePlayer;
import ui.GamePanel;
import ui.MainWindow;
import ui.Scene;

public class CreateGame
extends Scene
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private CreatePlayer[] players = new CreatePlayer[6];
    private JPanel playersPanel = new JPanel(new GridLayout(this.players.length, 1));

    public CreateGame() {
        super("Create game");
        this.setBackground(Color.BLACK);
        this.setLayout(new BorderLayout());
        int i = 0;
        while (i < this.players.length) {
            this.players[i] = new CreatePlayer(i + 1);
            this.playersPanel.add(this.players[i]);
            ++i;
        }
        this.players[0].activate();
        JLabel title = new JLabel("New Game", 0);
        title.setFont(new Font("Monospaced", 1, 50));
        title.setForeground(Color.WHITE);
        JButton play = new JButton("Play !");
        play.addActionListener(this);
        play.setCursor(Cursor.getPredefinedCursor(12));
        play.setToolTipText("begin the game");
        play.setFont(new Font("Monospaced", 1, 30));
        this.add((Component)title, "North");
        this.add((Component)new JScrollPane(this.playersPanel), "Center");
        this.add((Component)play, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Game game = new Game();
            CreatePlayer[] createPlayerArray = this.players;
            int n = this.players.length;
            int n2 = 0;
            while (n2 < n) {
                CreatePlayer p = createPlayerArray[n2];
                if (p.isActivated()) {
                    game.addPlayer(p.createPlayer(game));
                }
                ++n2;
            }
            game.start();
            MainWindow.getInstance().switchTo(new GamePanel(game));
            game.nextTurn();
        }
        catch (GameException err) {
            JOptionPane.showMessageDialog(this, err.getMessage(), "cannot create the game", 0);
        }
    }
}

