/*
 * Decompiled with CFR 0.152.
 */
package ui;

import core.Game;
import core.NameGenerator;
import core.Player;
import core.behaviors.StrongBehavior;
import core.behaviors.WeakBehavior;
import core.players.AIPlayer;
import core.players.HumanPlayer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ui.blocks.RoadPanel;

public class CreatePlayer
extends JPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private static final String[] TYPES = new String[]{"", "Human", "Computer"};
    private Color defaultBackground = Color.BLACK;
    private JTextField name = new JTextField(NameGenerator.getInstance().generateName());
    private JCheckBox strong = new JCheckBox("Strong");
    private JComboBox type = new JComboBox<String>(TYPES);
    private JPanel options = new JPanel();
    private JLabel avatar = new JLabel();
    private JSlider avatarID;

    public CreatePlayer(int id) {
        super(new BorderLayout());
        this.avatarID = new JSlider(1, 0, RoadPanel.CARS.length - 1, id - 1);
        this.avatarID.setPreferredSize(new Dimension(20, 85));
        this.setAvatar();
        this.type.addActionListener(this);
        this.avatarID.addChangeListener(this);
        this.setBorder(BorderFactory.createTitledBorder("Player " + id));
        this.setBackground(Color.BLACK);
        this.initComponents();
        this.addComponents();
    }

    private void setAvatar() {
        this.avatar.setIcon(new ImageIcon(RoadPanel.CARS[this.avatarID.getValue()]));
    }

    private void initComponents() {
        this.options.setOpaque(false);
        this.name.setToolTipText("Player's name");
        this.name.setPreferredSize(new Dimension(125, 35));
        this.name.setFont(new Font("Dialog", 1, 14));
    }

    private void addComponents() {
        this.add((Component)this.type, "West");
        this.add((Component)this.options, "Center");
        this.options.add(new JLabel("Name :"));
        this.options.add(this.name);
        this.options.add(this.getSpace(30));
        this.options.add(this.avatarID);
        this.options.add(this.avatar);
        this.options.add(this.getSpace(15));
        this.options.add(this.strong);
        this.options.setVisible(false);
        this.strong.setVisible(true);
    }

    private Component getSpace(int width) {
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setPreferredSize(new Dimension(width, 1));
        return p;
    }

    public String getPlayerName() {
        return this.name.getText();
    }

    public boolean isActivated() {
        return this.type.getSelectedItem() != TYPES[0];
    }

    public boolean isHuman() {
        return this.type.getSelectedItem() == TYPES[1];
    }

    public boolean isComputer() {
        return this.type.getSelectedItem() == TYPES[2];
    }

    public int getAvatarID() {
        return this.avatarID.getValue();
    }

    public void activate() {
        this.type.setSelectedItem(TYPES[1]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.type) {
            this.options.setVisible(this.isActivated());
            this.setBackground(this.isActivated() ? (this.isHuman() ? Color.LIGHT_GRAY : Color.GRAY) : this.defaultBackground);
            this.strong.setVisible(this.isComputer());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setAvatar();
    }

    public Player createPlayer(Game game) {
        if (!this.isActivated()) {
            throw new NullPointerException("cannot create a null player");
        }
        if (this.type.getSelectedItem() == TYPES[1]) {
            return new HumanPlayer(game, this.getPlayerName(), this.getAvatarID());
        }
        return new AIPlayer(game, this.getPlayerName(), this.getAvatarID(), this.strong.isSelected() ? new StrongBehavior() : new WeakBehavior());
    }
}

