/*
 * Decompiled with CFR 0.152.
 */
package ui;

import core.Card;
import core.Player;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.Border;
import ui.blocks.CardButton;

public class DrawWindow
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private CardButton draw;
    private CardButton discard;
    private LinkedList<Card> drawPile;
    private LinkedList<Card> discardPile;
    private Player drawer;
    private boolean clicked;

    public DrawWindow(Player drawer, LinkedList<Card> drawPile, LinkedList<Card> discardPile) {
        this.drawPile = drawPile;
        this.discardPile = discardPile;
        this.drawer = drawer;
        this.setUndecorated(true);
        this.setModal(true);
        this.setSize(CardButton.DIMENSION.width * 3, CardButton.DIMENSION.height + 120);
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setContentPane(this.createContainer());
    }

    private Container createContainer() {
        JPanel cont;
        JPanel p = new JPanel();
        p.setBackground(Color.DARK_GRAY);
        p.setBorder(this.createBorder("Draw a card", Color.LIGHT_GRAY));
        if (!this.drawPile.isEmpty()) {
            this.draw = new CardButton(this.drawPile.get(0), true);
            this.draw.addActionListener(this);
            cont = new JPanel();
            cont.setBorder(this.createBorder("Draw pile (" + this.drawPile.size() + ")", Color.WHITE));
            cont.setOpaque(false);
            cont.add(this.draw);
            p.add(cont);
        }
        if (!this.discardPile.isEmpty()) {
            this.discard = new CardButton(this.discardPile.get(0), false);
            this.discard.addActionListener(this);
            cont = new JPanel();
            cont.setBorder(this.createBorder("Discard pile (" + this.discardPile.size() + ")", Color.WHITE));
            cont.setOpaque(false);
            cont.add(this.discard);
            p.add(cont);
        }
        return p;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.clicked) {
            this.clicked = true;
            if (e.getSource() == this.draw) {
                this.draw.setHidden(false);
                this.drawer.getHand().add(this.drawPile.pop());
                this.closeAfter(750);
            } else {
                this.drawer.getHand().add(this.discardPile.pop());
                this.dispose();
            }
        }
    }

    private void closeAfter(final int time) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                DrawWindow.this.dispose();
            }
        }).start();
    }

    private Border createBorder(String title, Color color) {
        return BorderFactory.createTitledBorder(null, title, 0, 0, new Font("Dialog", 1, 16), color);
    }
}

