/*
 * Decompiled with CFR 0.152.
 */
package ui;

import core.Game;
import core.Player;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import ui.Scene;
import ui.blocks.HandPanel;
import ui.blocks.PlayerInformationPanel;
import ui.blocks.RoadPanel;

public class GamePanel
extends Scene
implements Observer {
    private static final long serialVersionUID = 1L;

    public GamePanel(Game game) {
        super("Game");
        this.setLayout(new BorderLayout());
        this.setBackground(Color.BLACK);
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        this.add((Component)panel, "North");
        for (Player p : game.getPlayers()) {
            PlayerInformationPanel piPanel = new PlayerInformationPanel(p);
            panel.add(piPanel);
        }
        RoadPanel rp = new RoadPanel(game);
        this.add((Component)rp, "Center");
        HandPanel hp = new HandPanel(game);
        this.add((Component)hp, "South");
        game.addObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.repaint();
    }
}

