/*
 * Decompiled with CFR 0.152.
 */
package ui.blocks;

import core.Card;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public class CardButton
extends JPanel {
    public static final Dimension DIMENSION = new Dimension(150, 200);
    private static final long serialVersionUID = 1L;
    private Image picture;
    private boolean over;
    private Card card;

    public CardButton(Card card, boolean hidden) {
        this.card = card;
        this.setPreferredSize(DIMENSION);
        this.setHidden(hidden);
        this.setOpaque(false);
        this.addMouseListener(new CardButtonListener());
    }

    public void setHidden(boolean hidden) {
        this.picture = hidden ? Card.defaultIcon : this.card.getIcon();
        this.setToolTipText(hidden ? "?" : this.card.toString().replace("_", " "));
        this.repaint();
    }

    public Card getCard() {
        return this.card;
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth() / 15;
        int h = this.getHeight() / 15;
        if (this.over) {
            g.drawImage(this.picture, 0, 0, this.getWidth(), this.getHeight(), null);
        } else {
            g.drawImage(this.picture, w / 2, h / 2, this.getWidth() - w, this.getHeight() - h, null);
        }
    }

    private class CardButtonListener
    extends MouseAdapter {
        private CardButtonListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ActionEvent event = new ActionEvent(e.getSource(), 1001, "card clicked");
            ActionListener[] actionListenerArray = (ActionListener[])CardButton.this.listenerList.getListeners(ActionListener.class);
            int n = actionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionListener listener = actionListenerArray[n2];
                listener.actionPerformed(event);
                ++n2;
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            CardButton.this.over = true;
            CardButton.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            CardButton.this.over = false;
            CardButton.this.repaint();
        }
    }
}

