/*
 * Decompiled with CFR 0.152.
 */
package ui.blocks;

import core.Card;
import core.Game;
import core.GameState;
import core.Player;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ui.ChooseCardListener;
import ui.blocks.CardButton;

public class HandPanel
extends JScrollPane
implements Observer {
    private static final long serialVersionUID = 1L;
    private JPanel cardsPanel = new JPanel();
    private Game game;

    public HandPanel(Game game) {
        this.game = game;
        this.setPreferredSize(new Dimension(0, CardButton.DIMENSION.height + 16));
        this.setViewportView(this.cardsPanel);
        this.cardsPanel.setBackground(Color.BLACK);
        this.setCards();
        game.addObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setCards();
    }

    private void setCards() {
        if (this.game.getState() != GameState.STARTED) {
            return;
        }
        Player currentPlayer = this.game.getCurrentPlayer();
        this.cardsPanel.removeAll();
        for (Card c : currentPlayer.getHand()) {
            CardButton cb = new CardButton(c, c.isHidden());
            cb.addActionListener(new ChooseCardListener(this.game, c));
            this.cardsPanel.add(cb);
        }
        this.validate();
    }
}

