/*
 * Decompiled with CFR 0.152.
 */
package ui.blocks;

import core.Player;
import core.cards.SafetyCard;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ui.blocks.CardButton;

public class PlayerInformationPanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = 1L;
    private Player player;
    private JLabel kms = new JLabel("--", 0);
    private JPanel cards = new JPanel(new GridLayout());

    public PlayerInformationPanel(Player player) {
        this.player = player;
        JLabel l = new JLabel("Kilometers : ");
        this.setOpaque(false);
        this.kms.setFont(new Font("Monospaced", 1, 16));
        l.setForeground(Color.WHITE);
        this.kms.setForeground(Color.WHITE);
        this.cards.setOpaque(false);
        this.add(l);
        this.add(this.kms);
        this.add(this.cards);
        this.updateValue();
        player.addObserver(this);
    }

    private void updateValue() {
        this.setBorder(BorderFactory.createTitledBorder(null, this.player.getName(), 0, 0, new Font("Dialog", 1, 12), this.player.canMove(null) ? Color.GREEN : Color.RED));
        this.kms.setText("" + this.player.getTotalDistance());
        this.cards.removeAll();
        this.cards.setPreferredSize(new Dimension(this.player.getSafeties().size() * 30 + (this.player.getHazard() == null ? 0 : 30), 40));
        for (SafetyCard c : this.player.getSafeties()) {
            CardButton cb = new CardButton(c, c.isHidden());
            this.cards.add(cb);
        }
        if (this.player.getHazard() != null) {
            this.cards.add(new CardButton(this.player.getHazard(), this.player.getHazard().isHidden()));
        }
        this.revalidate();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateValue();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.player.isTurn()) {
            g.setColor(Color.MAGENTA);
        } else {
            g.setColor(Color.GRAY);
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 25, 25);
    }
}

