/*
 * Decompiled with CFR 0.152.
 */
package ui.blocks;

import core.Game;
import core.Player;
import core.ResourcesManager;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import javax.swing.JPanel;
import ui.blocks.Tree;

public class RoadPanel
extends JPanel
implements Observer,
Runnable {
    public static final BufferedImage[] CARS = new BufferedImage[]{ResourcesManager.getInstance().getImage("cars/car_black.png"), ResourcesManager.getInstance().getImage("cars/car_blue.png"), ResourcesManager.getInstance().getImage("cars/car_blue_lighter.png"), ResourcesManager.getInstance().getImage("cars/car_purple.png"), ResourcesManager.getInstance().getImage("cars/car_red.png"), ResourcesManager.getInstance().getImage("cars/car_white.png")};
    private static final long serialVersionUID = 1L;
    private static final Composite ALPHA = AlphaComposite.getInstance(3, 0.7f);
    private static final Dimension CAR_DIM = new Dimension(129, 64);
    private static final Dimension INFO = new Dimension(50, 40);
    private static final int ROAD_WIDTH = 5500;
    private BufferedImage background = ResourcesManager.getInstance().getImage("backgrounds/grass.jpg");
    private ArrayList<Tree> trees = new ArrayList();
    private Game game;
    private int lastPosition;
    private int position;

    public RoadPanel(Game game) {
        this.game = game;
        Random r = new Random();
        int i = 0;
        while (i < 500) {
            this.trees.add(new Tree(new Point(r.nextInt(5500), 300 - r.nextInt(600)), r.nextInt(Tree.TREE_NUMBER)));
            ++i;
        }
        Collections.sort(this.trees);
        game.addObserver(this);
        this.lastPosition = this.getDX();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (Math.abs(this.getDX() - this.lastPosition) >= 10) {
            new Thread(this).start();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        this.drawBackground(g2d);
        this.drawRoad(g2d, this.position);
        this.drawPlayers(g2d, this.position);
        this.drawTrees(g2d, this.position);
        this.drawInfos(g2d, this.position);
    }

    private int getDX() {
        return (int)((float)this.game.getCurrentPlayer().getTotalDistance() / 1000.0f * 5500.0f);
    }

    private void drawTrees(Graphics2D g, int dx) {
        int dim = RoadPanel.CAR_DIM.height + 40;
        for (Tree t : this.trees) {
            t.draw(g, this.getHeight() / 2 - dim, this.getHeight() / 2 + dim, dx);
        }
    }

    private void drawBackground(Graphics2D g) {
        Paint tmp = g.getPaint();
        g.setPaint(new TexturePaint(this.background, new Rectangle(0, 0, this.background.getWidth(), this.background.getHeight())));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setPaint(tmp);
    }

    private void drawRoad(Graphics2D g, int dx) {
        int h = RoadPanel.CAR_DIM.height * 2 + 30;
        int y = (this.getHeight() - h) / 2;
        g.setPaint(new GradientPaint(new Point(0, y), Color.DARK_GRAY, new Point(0, y + h), Color.GRAY));
        g.fillRect(0, y, this.getWidth(), h + 10);
        g.setColor(Color.DARK_GRAY);
        g.fillRect(0, y + h + 10, this.getWidth(), 5);
        g.setColor(Color.BLACK);
        g.drawRect(-10, y, this.getWidth() + 20, h);
        g.drawRect(-10, y + h, this.getWidth() + 20, 10);
        g.drawRect(-10, y, this.getWidth() + 20, 7);
        g.drawRect(-10, y + h + 10, this.getWidth() + 20, 5);
        g.setColor(new Color(225, 225, 225));
        int x = 0;
        while (x < this.getWidth()) {
            g.fillRect(x, y + h / 2 - 5, RoadPanel.CAR_DIM.width, 7);
            x += RoadPanel.CAR_DIM.width * 2;
        }
        g.fillRect(this.getWidth() / 2 - 10 - dx, y + 11, 15, h - 15);
        g.fillRect(5500 + this.getWidth() / 2 - 10 - dx, y + 11, 15, h - 15);
    }

    private void drawPlayers(Graphics2D g, int dx) {
        for (Player p : this.game.getPlayers()) {
            int x = (int)((float)p.getTotalDistance() / 1000.0f * 5500.0f) - dx + this.getWidth() / 2 - RoadPanel.CAR_DIM.width;
            int y = (this.getHeight() - (RoadPanel.CAR_DIM.height * 2 + 15)) / 2 + (p.getAvatarId() % 2 == 0 ? RoadPanel.CAR_DIM.height + 10 : -5);
            g.drawImage(CARS[p.getAvatarId()], x, y, RoadPanel.CAR_DIM.width, RoadPanel.CAR_DIM.height, null);
        }
    }

    private void drawInfos(Graphics2D g, int dx) {
        for (Player p : this.game.getPlayers()) {
            int x = (int)((float)p.getTotalDistance() / 1000.0f * 5500.0f) - dx + this.getWidth() / 2 - RoadPanel.CAR_DIM.width;
            int y = (this.getHeight() - (RoadPanel.CAR_DIM.height * 2 + 15)) / 2 + (p.getAvatarId() % 2 == 0 ? RoadPanel.CAR_DIM.height + 10 : -5);
            this.drawInfos(p, g, x + CARS[p.getAvatarId()].getWidth() / 2 - RoadPanel.INFO.width / 2, y - RoadPanel.INFO.height + CARS[p.getAvatarId()].getHeight() / 5);
        }
    }

    private void drawInfos(Player player, Graphics2D g, int x, int y) {
        Composite tmp = g.getComposite();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setComposite(ALPHA);
        Polygon p = new Polygon(new int[]{x, x + RoadPanel.INFO.width, x + RoadPanel.INFO.width / 2, x}, new int[]{y, y, y + RoadPanel.INFO.height, y}, 4);
        g.setColor(player.canMove(null) ? Color.GREEN : Color.RED);
        g.drawPolygon(p);
        g.fillPolygon(p);
        g.setComposite(tmp);
        g.setColor(Color.BLACK);
        g.setFont(new Font("Dialog", 1, 14));
        g.drawString(player.getName(), x + RoadPanel.INFO.width / 2 - g.getFontMetrics().stringWidth(player.getName()) / 2, y + g.getFontMetrics().getAscent());
    }

    @Override
    public void run() {
        int dx = this.getDX();
        if (this.lastPosition < dx) {
            this.position = this.lastPosition;
            while (this.position <= dx) {
                this.refresh();
                this.position += 2;
            }
        } else {
            this.position = this.lastPosition;
            while (this.position >= dx) {
                this.refresh();
                this.position -= 2;
            }
        }
        this.lastPosition = this.position;
    }

    private void refresh() {
        try {
            Thread.sleep(1L);
            this.repaint();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

