/*
 * Decompiled with CFR 0.152.
 */
package huffman;

import huffman.Noeud;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnalyseOccurrences<E extends Comparable<? super E>> {
    private final Map<E, Integer> occurences = new HashMap<E, Integer>();
    private final int nombre;
    private Map<E, Float> ratios;

    public AnalyseOccurrences(E ... elements) {
        this(Arrays.asList(elements));
    }

    public AnalyseOccurrences(List<E> elements) {
        this.nombre = elements.size();
        int i = 0;
        while (i < this.nombre) {
            Comparable e = (Comparable)elements.get(i);
            if (!this.occurences.containsKey(e)) {
                this.occurences.put(e, 1);
            } else {
                this.occurences.put(e, this.occurences.get(e) + 1);
            }
            ++i;
        }
    }

    public int getNombreOccurences(E e) {
        return this.occurences.get(e);
    }

    public float getRatio(E e) {
        return (float)this.getNombreOccurences(e) / (float)this.nombre;
    }

    public Map<E, Integer> getOccurences() {
        return this.occurences;
    }

    public List<Noeud<Integer, E>> creerNoeuds() {
        ArrayList<Noeud<Integer, Noeud<Integer, Comparable>>> noeuds = new ArrayList<Noeud<Integer, Noeud<Integer, Comparable>>>();
        for (Map.Entry<E, Integer> e : this.occurences.entrySet()) {
            noeuds.add(new Noeud<Integer, Comparable>(e.getValue(), (Comparable)e.getKey()));
        }
        Collections.sort(noeuds);
        return noeuds;
    }

    public Map<E, Float> getRatios() {
        if (this.ratios == null) {
            this.ratios = new HashMap<E, Float>();
            for (Comparable e : this.occurences.keySet()) {
                this.ratios.put(e, Float.valueOf(this.getRatio(e)));
            }
        }
        return this.ratios;
    }

    public int getNombreTotal() {
        return this.nombre;
    }
}

