/*
 * Decompiled with CFR 0.152.
 */
package huffman;

import huffman.AnalyseOccurrences;
import huffman.TableCodage;
import io.Flux;
import java.util.Collection;
import java.util.List;

public class CodageHuffman<E extends Comparable<? super E>> {
    private final long tempsAnalyse;
    private final long tempsTableCodage;
    private final AnalyseOccurrences<E> analyse;
    private final TableCodage<E> table;
    private final Collection<E> contenu;
    private Flux flux;

    public CodageHuffman(List<E> contenu) {
        this.contenu = contenu;
        long t = System.currentTimeMillis();
        this.analyse = new AnalyseOccurrences<E>(contenu);
        this.tempsAnalyse = System.currentTimeMillis() - t;
        t = System.currentTimeMillis();
        this.table = new TableCodage<E>(this.analyse);
        this.tempsTableCodage = System.currentTimeMillis() - t;
    }

    public Flux getFlux() {
        if (this.flux == null) {
            this.flux = new Flux();
            for (Comparable e : this.contenu) {
                this.table.getCodages().get(e).ecrire(this.flux);
            }
        }
        return this.flux;
    }

    public AnalyseOccurrences<E> getAnalyse() {
        return this.analyse;
    }

    public TableCodage<E> getTable() {
        return this.table;
    }

    public Collection<E> getContenu() {
        return this.contenu;
    }

    public long getTempsAnalyse() {
        return this.tempsAnalyse;
    }

    public long getTempsTableCodage() {
        return this.tempsTableCodage;
    }
}

