/*
 * Decompiled with CFR 0.152.
 */
package huffman;

import huffman.ConstructeurClef;
import io.Flux;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;

public class Noeud<K extends Comparable<K>, V>
implements Comparable<Noeud<K, V>>,
TreeNode,
Enumeration<Noeud<K, V>> {
    private final K clef;
    private Noeud<K, V> parent;
    private Noeud<K, V> voisin;
    private Noeud<K, V> enfantG;
    private Noeud<K, V> enfantD;
    private List<Boolean> codage;
    private boolean droite;
    private V valeur;

    public Noeud(K clef) {
        this.clef = clef;
    }

    public Noeud(K clef, Noeud<K, V> enfantG, Noeud<K, V> enfantD) {
        this(clef);
        this.enfantG = enfantG;
        this.enfantD = enfantD;
    }

    public Noeud(K clef, V valeur) {
        this(clef);
        this.valeur = valeur;
    }

    public Noeud<K, V> getParent(ConstructeurClef<K> constructeur) {
        if (this.parent == null) {
            if (this.voisin == null) {
                throw new IllegalAccessError();
            }
            this.voisin.parent = this.parent = new Noeud<Comparable, V>((Comparable)constructeur.getClef(this.clef, this.voisin.clef), this.voisin, this);
        }
        return this.parent;
    }

    public void setVoisin(Noeud<K, V> voisin) {
        this.voisin = voisin;
    }

    public Noeud<K, V> getVoisin() {
        return this.voisin;
    }

    public V getValeur() {
        return this.valeur;
    }

    public K getClef() {
        return this.clef;
    }

    public Noeud<K, V> getEnfantG() {
        return this.enfantG;
    }

    public Noeud<K, V> getEnfantD() {
        return this.enfantD;
    }

    public boolean estFeuille() {
        return this.enfantG == null && this.enfantD == null;
    }

    public boolean estRacine() {
        return this.parent == null;
    }

    public boolean estDroite() {
        return !this.estRacine() && this.parent.getEnfantD() == this;
    }

    public void ecrire(Flux flux) {
        if (this.codage == null) {
            this.codage = new ArrayList<Boolean>();
            Noeud<K, V> p = this.parent;
            this.codage.add(this.estDroite());
            while (p != null && !p.estRacine()) {
                this.codage.add(p.estDroite());
                p = p.getParent(null);
            }
        }
        int i = this.codage.size() - 1;
        while (i >= 0) {
            flux.getBits().add(this.codage.get(i));
            --i;
        }
    }

    public String getArbre() {
        return this.getArbre(0);
    }

    public String getArbre(int d) {
        String ds = "";
        int i = 0;
        while (i < d) {
            ds = String.valueOf(ds) + "|";
            ++i;
        }
        String s = this.clef + (this.valeur == null ? "" : "(" + this.valeur + ")") + "\n";
        if (this.enfantD != null) {
            s = String.valueOf(s) + ds + "\\_" + this.enfantD.getArbre(d + 1);
        }
        if (this.enfantG != null) {
            s = String.valueOf(s) + ds + "|_" + this.enfantG.getArbre(d + 1);
        }
        return s;
    }

    public void dessinerLiens(Graphics2D g, int taille, int x) {
        this.dessinerLiens(g, taille, x, 0, false);
    }

    public void dessiner(Graphics2D g, int taille, int x) {
        this.dessiner(g, taille, x, 0, false);
    }

    public int getProfondeur() {
        return this.getProfondeur(0);
    }

    public int getProfondeur(int profondeur) {
        if (this.estFeuille()) {
            return profondeur;
        }
        return Math.max(this.enfantG == null ? 0 : this.enfantG.getProfondeur(profondeur + 1), this.enfantD == null ? 0 : this.enfantD.getProfondeur(profondeur + 1));
    }

    public void dessinerLiens(Graphics2D g, int taille, int x, int y, boolean droite) {
        if (!this.estRacine() && this.getParent(null).estRacine()) {
            droite = this.estDroite();
        }
        if (this.enfantD != null) {
            g.drawLine(x + taille / 2, y + taille / 2, x + (this.estRacine() || droite ? taille : 0) + taille / 2, (int)((double)y + (double)taille * 1.5 + (double)(taille / 2)));
            this.enfantD.dessinerLiens(g, taille, x + (this.estRacine() || droite ? taille : 0), (int)((double)y + (double)taille * 1.5), droite);
        }
        if (this.enfantG != null) {
            g.drawLine(x + taille / 2, y + taille / 2, x - (droite ? 0 : taille) + taille / 2, (int)((double)y + (double)taille * 1.5 + (double)(taille / 2)));
            this.enfantG.dessinerLiens(g, taille, x - (droite ? 0 : taille), (int)((double)y + (double)taille * 1.5), droite);
        }
    }

    public void dessiner(Graphics2D g, int taille, int x, int y, boolean droite) {
        if (!this.estRacine() && this.getParent(null).estRacine()) {
            droite = this.estDroite();
        }
        String s = this.clef + (this.getValeur() == null ? "" : ":" + this.getValeur());
        g.setPaint(new GradientPaint(x + taille / 2, y, Color.WHITE, x + taille, y + taille, Color.LIGHT_GRAY, true));
        g.fillOval(x, y, taille, taille);
        g.setColor(Color.BLACK);
        g.drawOval(x, y, taille, taille);
        g.drawString(s, x + (taille - g.getFontMetrics().stringWidth(s)) / 2, y + (taille + g.getFontMetrics().getHeight() / 2) / 2);
        if (this.enfantD != null) {
            this.enfantD.dessiner(g, taille, x + (this.estRacine() || droite ? taille : 0), (int)((double)y + (double)taille * 1.5), droite);
        }
        if (this.enfantG != null) {
            this.enfantG.dessiner(g, taille, x - (droite ? 0 : taille), (int)((double)y + (double)taille * 1.5), droite);
        }
    }

    public String toString() {
        if (this.estRacine()) {
            return "Racine : " + this.clef;
        }
        if (this.estFeuille()) {
            return "Feuille " + (this.estDroite() ? "droite" : "gauche") + " : " + this.clef + "=\"" + this.valeur + "\"";
        }
        return String.valueOf(this.estDroite() ? "Droite" : "Gauche") + " : " + this.clef;
    }

    @Override
    public int compareTo(Noeud<K, V> o) {
        return this.clef.compareTo(o.clef);
    }

    public Enumeration<Noeud<K, V>> children() {
        return this;
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.estFeuille();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return childIndex == 0 ? this.enfantG : this.enfantD;
    }

    @Override
    public int getChildCount() {
        return (this.enfantD == null ? 0 : 1) + (this.enfantG == null ? 0 : 1);
    }

    @Override
    public int getIndex(TreeNode node) {
        return node == this.enfantG ? 0 : 1;
    }

    @Override
    public TreeNode getParent() {
        return this.getParent(null);
    }

    @Override
    public boolean isLeaf() {
        return this.estFeuille();
    }

    @Override
    public boolean hasMoreElements() {
        return !this.droite;
    }

    @Override
    public Noeud<K, V> nextElement() {
        Noeud<K, V> n = this.droite ? this.enfantD : this.enfantG;
        this.droite = true;
        return n;
    }
}

