/*
 * Decompiled with CFR 0.152.
 */
package huffman;

import huffman.AnalyseOccurrences;
import huffman.ConstructeurClefEntiere;
import huffman.Noeud;
import io.Flux;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableCodage<E extends Comparable<? super E>> {
    private final Map<E, Noeud<Integer, E>> codages;
    private final Noeud<Integer, E> racine;

    public TableCodage(AnalyseOccurrences<E> analyse) {
        ConstructeurClefEntiere constructeur = new ConstructeurClefEntiere();
        List<Noeud<Integer, Noeud<Integer, E>>> noeuds = analyse.creerNoeuds();
        Noeud<Integer, E> n = null;
        int i = 0;
        while (i < noeuds.size()) {
            n = noeuds.get(i);
            if (++i >= noeuds.size()) continue;
            n.setVoisin(noeuds.get(i));
            Noeud<Integer, E> noeud = n.getParent(constructeur);
            boolean ajoute = false;
            int j = i;
            while (j < noeuds.size()) {
                if (noeuds.get(j).compareTo(noeud) > 0) {
                    noeuds.add(j, noeud);
                    ajoute = true;
                    break;
                }
                ++j;
            }
            if (!ajoute) {
                noeuds.add(noeud);
            }
            ++i;
        }
        this.racine = n;
        this.codages = new HashMap<E, Noeud<Integer, E>>();
        for (Noeud<Integer, E> noeud : noeuds) {
            if (noeud.getValeur() == null) continue;
            this.codages.put((Comparable)noeud.getValeur(), noeud);
        }
    }

    public Map<E, Noeud<Integer, E>> getCodages() {
        return this.codages;
    }

    public Noeud<Integer, E> getRacine() {
        return this.racine;
    }

    public List<E> decoder(Flux flux) {
        ArrayList<Comparable> liste = new ArrayList<Comparable>();
        int i = 0;
        while (i < flux.getBits().size()) {
            Noeud<Integer, E> noeud = this.racine;
            while (!noeud.estFeuille()) {
                noeud = flux.getBits().get(i) != false ? noeud.getEnfantD() : noeud.getEnfantG();
                ++i;
            }
            if (noeud.estRacine()) {
                ++i;
            }
            liste.add((Comparable)noeud.getValeur());
        }
        return liste;
    }
}

