/*
 * Decompiled with CFR 0.152.
 */
package io;

import io.Entree;
import io.Sortie;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class Flux {
    private final List<Boolean> bits = new ArrayList<Boolean>();

    public Flux() {
    }

    public Flux(Entree in) throws IOException {
        this();
        this.lire(in);
    }

    public List<Boolean> getBits() {
        return this.bits;
    }

    public void lire(Entree in) throws IOException {
        byte[] bt = new byte[4];
        if (in.read(bt) != bt.length) {
            throw new IOException("Pas assez d'elements a lire");
        }
        int taille = ByteBuffer.wrap(bt).getInt();
        this.bits.clear();
        int octet = 0;
        int lus = 8;
        int i = 0;
        while (i < taille) {
            if (lus == 8) {
                octet = in.read();
                lus = 0;
            }
            if (octet == -1) {
                throw new IOException("Plus d'octet disponible");
            }
            int decalage = 8 - lus - 1;
            int a = taille - i - decalage - 1;
            if (a < 0) {
                decalage += a;
            }
            this.bits.add((octet >> decalage & 1) == 1);
            ++i;
            ++lus;
        }
    }

    public void ecrire(Sortie out) throws IOException {
        out.write(ByteBuffer.allocate(4).putInt(this.bits.size()).array());
        int i = 0;
        while (i < this.bits.size()) {
            byte n = 0;
            int ib = 0;
            while (ib < 8 && i < this.bits.size()) {
                n = (byte)((n << 1) + (this.bits.get(i) != false ? 1 : 0));
                ++ib;
                ++i;
            }
            out.write(n);
        }
    }

    public String toString() {
        String s = "";
        for (Boolean b : this.bits) {
            s = String.valueOf(s) + (b != false ? "1" : "0");
        }
        return s;
    }
}

