/*
 * Decompiled with CFR 0.152.
 */
package ui;

import io.Fichiers;
import io.Images;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import ui.Ecran;
import ui.interfaces.ChoixFichierListener;

public class ChargeurFichier
extends Ecran
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final JProgressBar avancement;
    private final ChoixFichierListener l;
    private final JButton charger;
    private final JButton ok;
    private final JTextField chemin;
    private final boolean ouvre;

    public ChargeurFichier(ChoixFichierListener l, boolean ouvre) {
        this.l = l;
        this.ouvre = ouvre;
        this.setLayout(new BorderLayout());
        this.chemin = new JTextField();
        this.avancement = new JProgressBar();
        this.charger = new JButton(new ImageIcon(Images.getInstance().getImage(ouvre ? "open.png" : "export.png").getScaledInstance(30, 30, 16)));
        this.ok = new JButton(new ImageIcon(Images.getInstance().getImage("ok.png").getScaledInstance(30, 30, 16)));
        if (ouvre) {
            this.chemin.setToolTipText("Chemin vers le fichier \u00e0 analyser");
            this.charger.setToolTipText("Choisir un fichier...");
            this.ok.setToolTipText("Lancer l'analyse du fichier");
        } else {
            this.chemin.setToolTipText("Chemin vers le fichier d'enregistrement");
            this.charger.setToolTipText("Choisir un fichier...");
            this.ok.setToolTipText("Exporter");
        }
        this.avancement.setValue(100);
        this.charger.setFont(this.POLICE);
        this.chemin.setFont(this.POLICE);
        this.ok.setFont(this.POLICE);
        this.avancement.setVisible(false);
        this.avancement.setStringPainted(true);
        this.avancement.setFont(this.POLICE);
        this.charger.addActionListener(this);
        this.chemin.addActionListener(this);
        this.ok.addActionListener(this);
        this.add((Component)this.avancement, "South");
        this.add((Component)this.chemin, "Center");
        this.add((Component)this.charger, "West");
        this.add((Component)this.ok, "East");
    }

    public void lancer() {
        File f = new File(this.chemin.getText());
        if (!this.ouvre) {
            try {
                f.createNewFile();
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(null, "Impossible de cr\u00e9er le fichier :\n" + e1.getMessage());
            }
        }
        if (!f.exists() || f.isDirectory()) {
            JOptionPane.showMessageDialog(null, "Le fichier \"" + f + "\" n'existe pas");
        } else {
            try {
                this.l.choix(f);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Erreur. \n" + e.getMessage());
            }
        }
    }

    public void setActif(boolean actif) {
        this.avancement.setVisible(!actif);
        this.ok.setEnabled(actif);
        this.charger.setEnabled(actif);
        this.chemin.setEnabled(actif);
        this.validate();
        this.repaint();
    }

    public JProgressBar getAvancement() {
        return this.avancement;
    }

    public boolean estActif() {
        return this.avancement.isVisible();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.charger) {
            try {
                this.chemin.setText(Fichiers.getInstance().getFichier(this.ouvre).getAbsolutePath());
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else if (!this.chemin.getText().trim().isEmpty()) {
            this.lancer();
        }
    }
}

