/*
 * Decompiled with CFR 0.152.
 */
package ui;

import huffman.CodageHuffman;
import huffman.Texte;
import io.Fichiers;
import io.Images;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import ui.Apercu;
import ui.Arbre;
import ui.ChargeurFichier;
import ui.Ecran;
import ui.Exporteur;
import ui.Statistiques;
import ui.TableCodageGraphique;
import ui.interfaces.ChoixFichierListener;

public class EcranPrincipal
extends Ecran
implements Runnable,
ChoixFichierListener {
    private static final long serialVersionUID = 1L;
    private final TableCodageGraphique<Character> table;
    private final Statistiques<Character> stats;
    private final Apercu apercu;
    private final Apercu decodage;
    private final Apercu code;
    private final ChargeurFichier chargeur;
    private final JTabbedPane panelOnglets;
    private final Exporteur exporteur;
    private final JTree arbre2;
    private final Arbre arbre;
    private InputStream flux;

    public EcranPrincipal() {
        this.setLayout(new BorderLayout());
        this.setName("Huffman");
        this.chargeur = new ChargeurFichier(this, true);
        this.apercu = new Apercu();
        this.code = new Apercu();
        this.decodage = new Apercu();
        this.stats = new Statistiques();
        this.table = new TableCodageGraphique();
        this.arbre = new Arbre();
        this.arbre2 = new JTree();
        this.exporteur = new Exporteur();
        this.panelOnglets = new JTabbedPane(2);
        this.panelOnglets.add(this.apercu);
        this.panelOnglets.add(this.table);
        this.panelOnglets.add(this.code);
        this.panelOnglets.add(this.decodage);
        this.panelOnglets.add(this.arbre);
        this.panelOnglets.add(new JScrollPane(this.arbre2));
        this.panelOnglets.add(this.stats);
        this.panelOnglets.add(this.exporteur);
        this.setOnglet(0, "Contenu fichier", "Fichier");
        this.setOnglet(1, "Table", "Table de codage (.csv)");
        this.setOnglet(2, "Contenu cod\u00e9", "Contenu cod\u00e9");
        this.setOnglet(3, "D\u00e9codage", "Fichier");
        this.setOnglet(4, "Sch\u00e9ma", "build");
        this.setOnglet(5, "Arbre", "arbre");
        this.setOnglet(6, "Statistiques", "Statistiques (.html)");
        this.setOnglet(7, "Exporter", "save");
        this.panelOnglets.setEnabled(false);
        this.add((Component)this.panelOnglets, "Center");
        this.add((Component)this.chargeur, "North");
    }

    public void analyse(InputStream flux) {
        if (!this.chargeur.estActif()) {
            this.flux = flux;
            this.chargeur.setActif(false);
            new Thread(this).start();
        }
    }

    public void setEtape(int no, String texte) {
        this.chargeur.getAvancement().setString("(Etape " + no + "/3) " + texte + "...");
    }

    public void setAvancement(int rang) {
        this.chargeur.getAvancement().setValue(rang * 100 / 7);
    }

    public void setOnglet(int index, String titre, String image) {
        JPanel p = new JPanel(new BorderLayout());
        p.setPreferredSize(new Dimension(175, 50));
        p.setOpaque(false);
        p.add((Component)new JLabel(EcranPrincipal.icone(image)), "West");
        JLabel l = new JLabel(titre, 4);
        l.setFont(new Font("Dialog", 1, 16));
        p.add((Component)l, "East");
        this.panelOnglets.setTabComponentAt(index, p);
    }

    @Override
    public void run() {
        try {
            this.setEtape(1, "Lecture du fichier...");
            List<Character> contenu = Fichiers.lireFichier(this.flux);
            long global = System.currentTimeMillis();
            CodageHuffman<Character> c = new CodageHuffman<Character>(contenu);
            Texte txt = new Texte();
            long temps = 0L;
            this.setEtape(2, "Ecriture du fichier cod\u00e9");
            temps = System.currentTimeMillis();
            c.getFlux().ecrire(txt);
            temps = System.currentTimeMillis() - temps;
            this.setEtape(3, "D\u00e9codage du texte");
            long temps2 = System.currentTimeMillis();
            List<Character> decode = c.getTable().decoder(c.getFlux());
            temps2 = System.currentTimeMillis() - temps2;
            global = System.currentTimeMillis() - global;
            this.chargeur.getAvancement().setString("Mise \u00e0 jour de l'interface graphique...");
            this.panelOnglets.setEnabled(true);
            this.setAvancement(0);
            this.apercu.setTexte(contenu);
            this.setAvancement(1);
            this.code.setTexte(txt.getCaracteres());
            this.setAvancement(2);
            this.decodage.setTexte(decode);
            this.setAvancement(3);
            this.table.set(c);
            this.setAvancement(4);
            this.stats.set(c, txt.getCaracteres().size(), temps, temps2, global);
            this.setAvancement(5);
            this.exporteur.set(contenu, txt.getCaracteres(), this.stats, this.table);
            this.setAvancement(6);
            this.arbre.set(c.getTable().getCodages().size(), c.getTable().getRacine());
            this.setAvancement(7);
            this.arbre2.setModel(new DefaultTreeModel(c.getTable().getRacine()));
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, "Erreur : " + e1.getMessage());
            e1.printStackTrace();
        }
        this.chargeur.setActif(true);
        this.validate();
        this.repaint();
    }

    @Override
    public void choix(File fichier) throws Exception {
        this.analyse(Fichiers.getFluxFichier(fichier));
    }

    public static ImageIcon icone(String nom) {
        return new ImageIcon(Images.getInstance().getImage(String.valueOf(nom) + ".png"));
    }
}

