/*
 * Decompiled with CFR 0.152.
 */
package ui;

import io.FluxFichier;
import io.Images;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import ui.ChargeurFichier;
import ui.Ecran;
import ui.Statistiques;
import ui.interfaces.ChoixFichierListener;

public class Exporteur
extends Ecran
implements ChoixFichierListener {
    private static final long serialVersionUID = 1L;
    private static final String[] CHOIX = new String[]{"Fichier", "Contenu cod\u00e9", "Table de codage (.csv)", "Statistiques (.html)"};
    private final ChargeurFichier fichier;
    private final ButtonGroup groupe;
    private List<Character> contenu;
    private List<Character> code;
    private Statistiques<Character> stats;
    private TableModel table;

    public Exporteur() {
        this.setLayout(new BorderLayout());
        this.fichier = new ChargeurFichier(this, false);
        this.fichier.setPreferredSize(new Dimension(450, 50));
        this.add((Component)this.fichier, "North");
        JPanel centre = new JPanel(new GridLayout(CHOIX.length, 1));
        this.groupe = new ButtonGroup();
        String[] stringArray = CHOIX;
        int n = CHOIX.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            JPanel p = new JPanel();
            p.setBorder(new TitledBorder(""));
            JRadioButton b = new JRadioButton(s);
            b.setActionCommand(s);
            b.setFont(this.POLICE);
            p.add(new JLabel(new ImageIcon(Images.getInstance().getImage(String.valueOf(s) + ".png"))));
            p.add(Box.createRigidArea(new Dimension(50, 50)));
            p.add(b);
            centre.add(p);
            this.groupe.add(b);
            this.groupe.setSelected(b.getModel(), true);
            ++n2;
        }
        this.add((Component)centre, "Center");
    }

    @Override
    public void choix(File fichier) throws Exception {
        int i = 0;
        while (i < CHOIX.length) {
            if (CHOIX[i].equals(this.groupe.getSelection().getActionCommand())) {
                this.choix(fichier, i);
                break;
            }
            ++i;
        }
    }

    public void choix(File fichier, int i) throws IOException {
        FluxFichier flux = new FluxFichier(fichier);
        switch (i) {
            case 0: {
                for (char c : this.contenu) {
                    flux.ecrire(c);
                }
                break;
            }
            case 1: {
                for (char c : this.code) {
                    flux.ecrire(c);
                }
                break;
            }
            case 2: {
                int l = 0;
                while (l < this.table.getRowCount()) {
                    int c = 0;
                    while (c < this.table.getColumnCount()) {
                        String s = "" + this.table.getValueAt(l, c);
                        if (";".equals(s)) {
                            s = "Point-virgule";
                        } else if ("\n".equals(s)) {
                            s = "Retour ligne";
                        } else if (" ".equals(s)) {
                            s = "Espace";
                        }
                        byte[] byArray = s.getBytes();
                        int n = byArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            byte b = byArray[n2];
                            flux.ecrire(b);
                            ++n2;
                        }
                        flux.ecrire(59);
                        ++c;
                    }
                    flux.ecrire(10);
                    ++l;
                }
                break;
            }
            case 3: {
                flux.write(this.stats.getTexte().getBytes());
            }
        }
        flux.getOut().close();
        JOptionPane.showMessageDialog(null, String.valueOf(fichier.getName()) + " export\u00e9 avec succ\u00e8s");
    }

    public void set(List<Character> contenu, List<Character> code, Statistiques<Character> stats, TableModel table) {
        this.contenu = contenu;
        this.code = code;
        this.stats = stats;
        this.table = table;
    }
}

