/*
 * Decompiled with CFR 0.152.
 */
package ui;

import huffman.AnalyseOccurrences;
import huffman.CodageHuffman;
import huffman.Noeud;
import huffman.TableCodage;
import io.Flux;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import ui.Ecran;

public class TableCodageGraphique<E extends Comparable<? super E>>
extends Ecran
implements TableModel {
    private static final String[] COLONNES = new String[]{"Element", "Nombre d'occurrences", "Fr\u00e9quence d'apparition", "Taille du codage", "Codage binaire"};
    private static final long serialVersionUID = 1L;
    private List<Map.Entry<E, Noeud<Integer, E>>> elements;
    private AnalyseOccurrences<E> analyse;

    public TableCodageGraphique() {
        this.setLayout(new GridLayout());
        JTable t = new JTable(this);
        t.setAutoCreateRowSorter(true);
        this.add(new JScrollPane(t));
    }

    public void set(TableCodage<E> table, AnalyseOccurrences<E> analyse) {
        this.analyse = analyse;
        this.elements = new ArrayList<Map.Entry<E, Noeud<Integer, E>>>();
        for (Map.Entry<E, Noeud<Integer, E>> entry : table.getCodages().entrySet()) {
            this.elements.add(entry);
        }
        TableModelEvent tableModelEvent = new TableModelEvent(this);
        TableModelListener[] tableModelListenerArray = (TableModelListener[])this.listenerList.getListeners(TableModelListener.class);
        int n = tableModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableModelListener l = tableModelListenerArray[n2];
            l.tableChanged(tableModelEvent);
            ++n2;
        }
    }

    public void set(CodageHuffman<E> c) {
        this.set(c.getTable(), c.getAnalyse());
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 1: 
            case 3: {
                return Integer.class;
            }
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return COLONNES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLONNES[columnIndex];
    }

    @Override
    public int getRowCount() {
        if (this.elements == null) {
            return 0;
        }
        return this.elements.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Map.Entry<E, Noeud<Integer, E>> e = this.elements.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return "" + e.getKey();
            }
            case 1: {
                return this.analyse.getNombreOccurences((Comparable)e.getKey());
            }
            case 2: {
                return String.valueOf(this.analyse.getRatio((Comparable)e.getKey()) * 100.0f) + "%";
            }
            case 3: {
                Flux ff = new Flux();
                e.getValue().ecrire(ff);
                return ff.getBits().size();
            }
            case 4: {
                Flux f = new Flux();
                e.getValue().ecrire(f);
                return f.toString();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }
}

