/*
 * Decompiled with CFR 0.152.
 */
package ecrans;

import base.Ecran;
import base.Fenetre;
import base.Outil;
import composants.ListeGraphique;
import composants.MenuContextuel;
import ecrans.EcranAccueil;
import ecrans.EcranCourse;
import ecrans.EcranGestionCourse;
import ecrans.EcranResultats;
import elements.Course;
import elements.Resultats;
import exceptions.AnnulationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ressources.Images;
import ressources.ListeCourses;
import special.RenduCourse;

public class EcranListeCourses
extends Ecran
implements ActionListener,
ListSelectionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private static EcranListeCourses instance;
    private final Map<Course, Ecran> courses;
    protected final JButton nouveau;
    protected final JButton retour;
    protected final JButton suppr;
    protected final JButton edit;
    protected final JButton lancer;
    protected final JButton result;
    protected final ListeGraphique<Course> liste;
    private final JComponent j1;
    private final JComponent j2;
    private final JComponent j3;
    private final JComponent j4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EcranListeCourses getInstance() {
        Class<EcranListeCourses> clazz = EcranListeCourses.class;
        synchronized (EcranListeCourses.class) {
            if (instance == null) {
                instance = new EcranListeCourses();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected EcranListeCourses() {
        super(new BorderLayout());
        this.setImage("fonds/fond.jpg");
        this.setMax(true);
        JPanel haut = new JPanel(new GridLayout());
        haut.setOpaque(false);
        this.add((Component)haut, "North");
        this.retour = new JButton(Images.getIcone("divers/retour.png", 32));
        this.nouveau = new JButton("Nouveau", Images.getIcone("divers/new.png", 32));
        this.edit = new JButton("Editer", Images.getIcone("divers/edit.png", 32));
        this.suppr = new JButton("Supprimer", Images.getIcone("divers/suppr.png", 32));
        this.result = new JButton("R\u00e9sultat", Images.getIcone("divers/result.png", 32));
        this.lancer = new JButton("Lancer", Images.getIcone("divers/ok.png", 32));
        this.courses = new HashMap<Course, Ecran>();
        this.liste = new ListeGraphique("Courses", ListeCourses.getInstance(), this, new RenduCourse());
        this.add(this.liste);
        this.retour.addActionListener(this);
        this.nouveau.addActionListener(this);
        this.edit.addActionListener(this);
        this.result.addActionListener(this);
        this.suppr.addActionListener(this);
        this.lancer.addActionListener(this);
        this.liste.getListe().addKeyListener(this);
        this.liste.getListe().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    if (EcranListeCourses.this.result.isEnabled()) {
                        EcranListeCourses.this.result();
                    } else {
                        EcranListeCourses.this.editer();
                    }
                }
            }
        });
        MenuContextuel m = new MenuContextuel(this.liste.getListe());
        m.ajoutMenu((ActionListener)this, "Retour", Images.getIcone("divers/retour.png", 20));
        m.ajoutMenu((ActionListener)this, "Nouveau", Images.getIcone("divers/new.png", 20));
        this.j1 = m.ajoutMenu((ActionListener)this, "Editer", Images.getIcone("divers/edit.png", 20));
        this.j2 = m.ajoutMenu((ActionListener)this, "Supprimer", Images.getIcone("divers/suppr.png", 20));
        this.j3 = m.ajoutMenu((ActionListener)this, "Lancer", Images.getIcone("divers/ok.png", 20));
        this.j4 = m.ajoutMenu((ActionListener)this, "R\u00e9sultat", Images.getIcone("divers/result.png", 20));
        this.actualise();
    }

    public void actualise() {
        this.masquer(!this.liste.getListe().isSelectionEmpty());
    }

    public void masquer(boolean visible) {
        this.edit.setEnabled(visible);
        this.suppr.setEnabled(visible);
        this.lancer.setEnabled(visible);
        this.j1.setEnabled(visible);
        this.j2.setEnabled(visible);
        this.j3.setEnabled(visible);
        boolean existe = visible && this.liste.getSelection() != null && Resultats.existe(this.liste.getSelection().getNom());
        this.result.setEnabled(existe);
        this.j4.setEnabled(existe);
    }

    public void supprimer() {
        if (this.liste.getSelection() != null && Outil.confirmer("Supprimer cette course ?")) {
            ListeCourses.getInstance().supprimeCourse(this.liste.getSelection());
            this.liste.getListe().setSelectedIndex(-1);
            this.actualise();
        }
    }

    public void editer() {
        Course c = this.liste.getSelection();
        if (c != null) {
            if (!this.courses.containsKey(c)) {
                this.courses.put(c, new EcranGestionCourse(c));
            }
            this.getFenetre().changer(this.courses.get(c));
        }
    }

    public void result() {
        if (Resultats.existe(this.liste.getSelection().getNom())) {
            this.changer(new EcranResultats(new Resultats(this.liste.getSelection().getNom())));
        }
    }

    public void nouvelleCourse() {
        block2: {
            try {
                ListeCourses.getInstance().ajoutCourse(Outil.demander("Nom de la course ?"));
            }
            catch (AnnulationException e) {
                if (e.getMessage() == null) break block2;
                Outil.erreur(e.getMessage());
            }
        }
        this.actualise();
    }

    public void lancer() {
        if (this.liste.getSelection() != null) {
            if (this.liste.getSelection().getListe().isEmpty()) {
                Outil.erreur("Cette course n'a aucun participant");
            } else if (!Resultats.existe(this.liste.getSelection().getNom()) || Outil.confirmer("Cette course a d\u00e9j\u00e0 \u00e9t\u00e9 courue. Relancer ?")) {
                this.getFenetre().changer(new EcranCourse(this.liste.getSelection()));
            }
        }
    }

    @Override
    public void afficher(Fenetre fenetre) {
        super.afficher(fenetre);
        this.liste.getListe().setSelectedIndex(-1);
        this.actualise();
    }

    @Override
    public String getTitre() {
        return "Courses";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.nouveau || "nouveau".equalsIgnoreCase(e.getActionCommand())) {
            this.nouvelleCourse();
        } else if (e.getSource() == this.retour || "retour".equalsIgnoreCase(e.getActionCommand())) {
            this.changer(EcranAccueil.getInstance());
        }
        if (e.getSource() == this.edit || "editer".equalsIgnoreCase(e.getActionCommand())) {
            this.editer();
        } else if (e.getSource() == this.suppr || "supprimer".equalsIgnoreCase(e.getActionCommand())) {
            this.supprimer();
        } else if (e.getSource() == this.lancer || "lancer".equalsIgnoreCase(e.getActionCommand())) {
            this.lancer();
        } else if (e.getSource() == this.result || "r\u00e9sultat".equalsIgnoreCase(e.getActionCommand())) {
            this.result();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.actualise();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            this.supprimer();
        } else if (e.getKeyCode() == 10) {
            this.editer();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public JComponent[] getMenu() {
        return new JComponent[]{this.retour, this.nouveau, this.suppr, this.edit, this.lancer, this.result};
    }
}

