/*
 * Decompiled with CFR 0.152.
 */
package ecrans;

import base.Ecran;
import base.Outil;
import ecrans.Classements;
import ecrans.EcranAccueil;
import elements.Ensemble;
import elements.EnsembleFiltre;
import elements.Resultats;
import exceptions.AnnulationException;
import filtre.Filtre;
import filtres.PanelFiltresResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import ressources.Images;

public class EcranResultats
extends Ecran
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final AbstractButton save;
    private final AbstractButton menu;
    private final Resultats resultats;
    private final JPanel centre;
    private final EnsembleFiltre ef;
    private Ensemble r;
    private final PanelFiltresResult pf;
    private final Classements c;

    public EcranResultats(Resultats resultats) {
        this.ef = new EnsembleFiltre(resultats);
        this.c = new Classements(this);
        this.pf = new PanelFiltresResult(this.c, this.ef);
        this.setLayout(new BorderLayout());
        this.setImage("fonds/fond.jpg");
        this.setMax(true);
        this.resultats = resultats;
        this.centre = new JPanel();
        this.add((Component)new JScrollPane(this.centre), "Center");
        this.centre.setOpaque(false);
        this.centre.setLayout(new BoxLayout(this.centre, 1));
        JPanel haut = new JPanel(new BorderLayout());
        JPanel gauche = new JPanel(new GridLayout(2, 1));
        haut.setOpaque(false);
        gauche.setOpaque(false);
        haut.add((Component)gauche, "West");
        haut.add((Component)this.c, "North");
        haut.add((Component)this.pf, "Center");
        this.menu = new JButton("Accueil", Images.getIcone("divers/retour.png", 32));
        this.save = new JButton("Enregistrer sous...", Images.getIcone("divers/save.png", 32));
        this.add((Component)haut, "North");
        this.menu.addActionListener(this);
        this.save.addActionListener(this);
        this.setResultat(resultats);
        this.pf.nouveau();
    }

    public Ensemble getModele() {
        return this.ef.getModele();
    }

    public Ensemble getBase() {
        return this.ef.getEnsemble();
    }

    public void setResultat(Ensemble r) {
        List<Filtre> f = this.pf.getFiltres();
        f.add(this.c);
        this.ef.filtrer(f);
        f.remove(this.c);
        this.afficheResultat(this.ef.getModele());
    }

    public void afficheResultat(Ensemble r) {
        this.r = r;
        this.centre.removeAll();
        JTable t = new JTable(r);
        t.setAutoCreateRowSorter(true);
        t.setDragEnabled(true);
        this.centre.add(new JScrollPane(t));
        this.validate();
        this.repaint();
    }

    @Override
    public String getTitre() {
        return this.resultats.getNom();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.menu) {
            this.changer(EcranAccueil.getInstance());
        } else if (e.getSource() == this.save) {
            try {
                this.r.exporter();
            }
            catch (FileNotFoundException err) {
                Outil.erreur(err.getMessage());
            }
            catch (AnnulationException annulationException) {
                // empty catch block
            }
        }
    }

    @Override
    public JComponent[] getMenu() {
        return new JComponent[]{this.menu, this.save};
    }
}

