/*
 * Decompiled with CFR 0.152.
 */
package elements;

import elements.Ensemble;
import elements.Participant;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Groupe
extends Ensemble {
    private static final long serialVersionUID = 1L;
    public static final String PATH = "groupes/";
    private boolean editable;

    public Groupe(File f, boolean editable) {
        super(f);
        this.editable = editable;
    }

    public Groupe(String nom) {
        super(nom);
    }

    public Groupe recharger() {
        return new Groupe(this.getFichier(), false);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.editable;
    }

    @Override
    public String getPath() {
        return PATH;
    }

    @Override
    public int getRowCount() {
        return super.getRowCount() + (this.editable ? 1 : 0);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.editable && rowIndex == this.getListe().size()) {
            return "";
        }
        return super.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.editable && rowIndex == this.getListe().size()) {
            if (rowIndex < 1 || !this.getListe().get(rowIndex - 1).estVide()) {
                Participant p = new Participant(new ArrayList<String>());
                p.setChamp(columnIndex, aValue);
                this.ajout(p);
            }
        } else {
            super.setValueAt(aValue, rowIndex, columnIndex);
        }
    }

    @Override
    public Participant getParticipantFichier(List<String> champs) {
        return new Participant(champs);
    }
}

