/*
 * Decompiled with CFR 0.152.
 */
package elements;

import elements.Course;
import elements.Ensemble;
import elements.Participant;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ressources.Fichiers;

public class Resultats
extends Ensemble {
    private static final long serialVersionUID = 1L;
    public static final String PATH = "resultats/";
    private Map<Participant, String> temps;
    private long debut;
    private boolean fromFile;
    private int points;

    public Resultats(Course course) {
        super(course.getNom(), course.getColonnes(), new ArrayList<Participant>());
        this.temps = new HashMap<Participant, String>();
    }

    public Resultats(File file) {
        super(file);
        this.fromFile = true;
    }

    public Resultats(String nom) {
        this(Fichiers.getFichier(PATH + nom + ".csv", true));
    }

    public Resultats(String nom, boolean nul) {
        super(nom);
        this.fromFile = true;
    }

    public void setDebut(long debut) {
        this.debut = debut;
    }

    public long getDebut() {
        return this.debut;
    }

    public void arrive(Participant p) {
        this.arrive(p, this.getTemps());
    }

    public void arrive(Participant p, String temps) {
        this.temps.put(p, temps);
        this.ajout(p);
    }

    public String getTemps() {
        long t = System.currentTimeMillis() - this.debut;
        int s = (int)(t / 1000L % 60L);
        return String.valueOf(t / 60000L) + ":" + (s < 10 ? "0" : "") + s;
    }

    public void setPoints(int points) {
        this.points = points;
    }

    public int getPoints() {
        return this.points;
    }

    public boolean aFini(int index) {
        return this.aFini(this.getListe().get(index));
    }

    public boolean aFini(Participant p) {
        return this.temps.containsKey(p) && this.temps.get(p) != null && !this.temps.get(p).trim().isEmpty();
    }

    @Override
    public String getPath() {
        return PATH;
    }

    public static boolean existe(String nom) {
        return Fichiers.existe(PATH + nom + ".csv");
    }

    @Override
    public Participant getParticipantFichier(List<String> champs) {
        return new Participant(champs);
    }

    @Override
    public int getColumnCount() {
        if (this.fromFile) {
            return super.getColumnCount();
        }
        return super.getColumnCount() + 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (this.fromFile) {
            return super.getColumnName(columnIndex);
        }
        switch (columnIndex) {
            case 0: {
                return "Classement";
            }
            case 1: {
                return "Temps";
            }
        }
        return super.getColumnName(columnIndex - 2);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.fromFile) {
            return super.getValueAt(rowIndex, columnIndex);
        }
        switch (columnIndex) {
            case 0: {
                return this.aFini(rowIndex) ? Integer.valueOf(rowIndex + 1) : "Non class\u00e9";
            }
            case 1: {
                return this.aFini(rowIndex) ? this.temps.get(this.getListe().get(rowIndex)) : "";
            }
        }
        return super.getValueAt(rowIndex, columnIndex - 2);
    }
}

