/*
 * Decompiled with CFR 0.152.
 */
package filtres;

import elements.EnsembleFiltre;
import filtre.Filtre;
import filtre.FiltreListener;
import filtres.FiltreGraphique;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class PanelFiltres
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final List<Filtre> filtres;
    private final EnsembleFiltre ef;

    public PanelFiltres(EnsembleFiltre ef) {
        super(new GridLayout(0, 1));
        this.addFiltreListener(ef);
        this.setBorder(new TitledBorder("Filtrer"));
        this.setOpaque(false);
        this.ef = ef;
        this.filtres = new ArrayList<Filtre>();
        this.nouveau();
    }

    public void filtrer() {
        this.notifyFiltreListener();
    }

    public void ajoutFiltre(FiltreGraphique f) {
        this.filtres.add(f);
        this.add(f);
        this.notifyFiltreListener();
    }

    public void retire(FiltreGraphique filtreGraphique) {
        if (this.getComponentCount() > 1) {
            this.remove(filtreGraphique);
        }
        this.filtres.remove(filtreGraphique);
        this.validate();
        this.repaint();
        if (this.getParent() != null) {
            this.getParent().validate();
            this.getParent().repaint();
        }
        this.notifyFiltreListener();
    }

    public void nouveau() {
        if (this.getComponentCount() < 1 || ((FiltreGraphique)this.getComponent(this.getComponentCount() - 1)).filtre()) {
            this.ajoutFiltre(new FiltreGraphique(this, this.ef));
        } else {
            this.filtrer();
        }
    }

    public PanelFiltres addFiltreListener(FiltreListener l) {
        this.listenerList.add(FiltreListener.class, l);
        return this;
    }

    public void removeFiltreListener(FiltreListener l) {
        this.listenerList.remove(FiltreListener.class, l);
    }

    public void notifyFiltreListener() {
        FiltreListener[] filtreListenerArray = (FiltreListener[])this.listenerList.getListeners(FiltreListener.class);
        int n = filtreListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            FiltreListener l = filtreListenerArray[n2];
            l.filtrer(this.filtres);
            ++n2;
        }
    }
}

