/*
 * Decompiled with CFR 0.152.
 */
package special;

import base.Outil;
import composants.MenuContextuel;
import elements.Groupe;
import exceptions.AnnulationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import ressources.Images;

public class PanelGroupe
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final AbstractButton save;
    private final AbstractButton exporter;
    private JTable table;
    private final Groupe groupe;
    private JScrollPane jsp;
    private final JPanel haut;

    public PanelGroupe(Groupe groupe) {
        super(new BorderLayout());
        this.setOpaque(false);
        this.groupe = groupe;
        this.table = new JTable(groupe);
        this.jsp = new JScrollPane(this.table);
        this.add((Component)this.jsp, "Center");
        this.table.setAutoCreateColumnsFromModel(true);
        this.table.setAutoCreateRowSorter(true);
        this.table.setAutoscrolls(true);
        this.table.setAutoResizeMode(3);
        this.table.setDragEnabled(true);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.haut = new JPanel(new GridLayout());
        this.haut.setOpaque(false);
        this.save = new JButton("Enregistrer", Images.getIcone("divers/save.png", 32));
        this.haut.add(this.save);
        this.exporter = new JButton("Enregistrer sous...", Images.getIcone("divers/exporter.png", 32));
        this.haut.add(this.exporter);
        this.save.addActionListener(this);
        this.exporter.addActionListener(this);
        this.add((Component)this.haut, "North");
        MenuContextuel m = new MenuContextuel(this.table);
        m.ajoutMenu((ActionListener)this, "Enregistrer", Images.getIcone("divers/save.png", 20));
        m.ajoutMenu((ActionListener)this, "Exporter", Images.getIcone("divers/exporter.png", 20));
        m.ajoutMenu((ActionListener)this, "Supprimer le participant", Images.getIcone("divers/suppr.png", 20));
    }

    public JPanel getHaut() {
        return this.haut;
    }

    public void actualise() {
        this.table = new JTable(this.groupe);
        this.jsp.setViewportView(this.table);
        this.table.setAutoCreateColumnsFromModel(true);
        this.table.setAutoCreateRowSorter(true);
        this.table.setAutoscrolls(true);
        this.table.setAutoResizeMode(3);
        this.table.setDragEnabled(true);
        this.table.setSurrendersFocusOnKeystroke(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.save || "enregistrer".equalsIgnoreCase(e.getActionCommand())) {
                this.groupe.enregister();
            } else if (e.getSource() == this.exporter || "exporter".equalsIgnoreCase(e.getActionCommand())) {
                this.groupe.exporter();
            } else if ("Supprimer le participant".equalsIgnoreCase(e.getActionCommand()) && this.table.getSelectedRow() != -1 && this.table.getSelectedRow() < this.groupe.getListe().size()) {
                this.groupe.supprime(this.groupe.getListe().get(this.table.getSelectedRow()));
                this.groupe.change();
            }
        }
        catch (FileNotFoundException err) {
            Outil.erreur("Fichier non trouv\u00e9\n" + err.getMessage());
        }
        catch (AnnulationException annulationException) {
            // empty catch block
        }
    }
}

