/*
 * Decompiled with CFR 0.152.
 */
package special;

import base.Style;
import ecrans.EcranCourse;
import elements.Participant;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import ressources.Images;
import special.NombreParticipants;

public class SaisieDossard
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final ImageIcon bon;
    private final ImageIcon mauvais;
    private final ImageIcon done;
    private final NombreParticipants n;
    private final EcranCourse course;
    private final JTextField txt;
    private final AbstractButton ok;
    private final JLabel label;
    private final int dossard;
    private Participant p;

    public SaisieDossard(EcranCourse course) {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(new TitledBorder(""));
        this.course = course;
        this.dossard = course.getCourse().getIndexDossard();
        this.txt = new JTextField();
        this.add((Component)this.txt, "Center");
        this.ok = new JButton(Images.getIcone("divers/ok.png", 32));
        this.add((Component)this.ok, "East");
        this.n = new NombreParticipants(course.getCourse().getListe().size());
        this.add((Component)this.n, "West");
        this.label = new JLabel("Une fois que le coureur a fini la course, entrer son num\u00e9ro de dossard ci-dessous", 0);
        this.add((Component)this.label, "North");
        this.txt.setFont(Style.TITRE.deriveFont(25.0f));
        this.txt.setHorizontalAlignment(0);
        this.txt.addActionListener(this);
        this.ok.addActionListener(this);
        this.label.setFont(Style.POLICE.deriveFont(20.0f));
        this.txt.requestFocus();
        this.txt.setBackground(new Color(255, 255, 150));
        this.txt.setDocument(new Doc());
        this.ok.setEnabled(false);
        this.bon = Images.getIcone("divers/valide.png", 32);
        this.mauvais = Images.getIcone("divers/invalide.png", 32);
        this.done = Images.getIcone("divers/ok.png", 32);
    }

    public void focus() {
        this.txt.requestFocus();
    }

    public boolean arrive() {
        if (this.p != null) {
            if (!this.course.arrive(this.p)) {
                return false;
            }
            this.n.moins();
            this.p = null;
            return true;
        }
        return false;
    }

    public void actualise(String dossard) {
        this.p = null;
        for (Participant pt : this.course.getCourse().getListe()) {
            try {
                if (!pt.getChamp(this.dossard).equals(dossard)) continue;
                this.p = pt;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.p != null) {
            if (this.course.getResultats().contient(this.p)) {
                this.label.setText(String.valueOf(this.p.toString()) + " est d\u00e9j\u00e0 arriv\u00e9(e)");
                this.label.setIcon(this.mauvais);
                this.ok.setEnabled(false);
            } else {
                this.label.setText(this.p.toString());
                this.label.setIcon(this.bon);
                this.ok.setEnabled(true);
            }
        } else {
            this.p = null;
            this.label.setText(String.valueOf(this.n.getN()) + " restants");
            this.label.setIcon(null);
            this.ok.setEnabled(false);
        }
    }

    public void essayeArrive() {
        Participant p = this.p;
        if (p == null) {
            this.label.setText(String.valueOf(this.n.getN()) + " restants");
            this.label.setIcon(null);
        } else if (this.arrive()) {
            this.txt.setText("");
            this.label.setText(p + " est arriv\u00e9(e)");
            this.label.setIcon(this.done);
        } else {
            this.label.setText(p + " est d\u00e9j\u00e0 arriv\u00e9(e)");
            this.label.setIcon(this.mauvais);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.essayeArrive();
        this.ok.setEnabled(false);
        this.txt.requestFocus();
    }

    private class Doc
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        private Doc() {
        }

        @Override
        protected void fireRemoveUpdate(DocumentEvent e) {
            super.fireRemoveUpdate(e);
            SaisieDossard.this.actualise(SaisieDossard.this.txt.getText());
        }

        @Override
        public void insertString(int off, String s, AttributeSet a) throws BadLocationException {
            super.insertString(off, s, a);
            SaisieDossard.this.actualise(SaisieDossard.this.txt.getText());
        }
    }
}

