/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.Fenetre;
import base.Style;
import composants.PanelImage;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import ressources.Images;

public abstract class Ecran
extends PanelImage {
    private static final long serialVersionUID = 1L;
    private Fenetre fenetre;

    public Ecran() {
        this(new GridLayout());
    }

    public Ecran(String image) {
        this(Images.get(image));
    }

    public Ecran(LayoutManager layout) {
        this.setLayout(layout);
    }

    public Ecran(BufferedImage image) {
        super(image, true);
    }

    public abstract String getTitre();

    public abstract JComponent[] getMenu();

    public void setFenetre(Fenetre fenetre) {
        this.fenetre = fenetre;
        this.afficher(fenetre);
    }

    public Fenetre getFenetre() {
        return this.fenetre == null ? Fenetre.getInstance() : this.fenetre;
    }

    public void changer(Ecran nouveau) {
        this.fenetre.changer(nouveau);
    }

    public void setBordure(String nom) {
        this.setBorder(BorderFactory.createTitledBorder(null, nom, 0, 0, Style.TITRE));
    }

    public void setBordureCentre(String nom) {
        this.setBorder(BorderFactory.createTitledBorder(null, nom, 2, 2, Style.TITRE));
    }

    public void afficher(Fenetre fenetre) {
    }

    public void fermer() {
    }
}

