/*
 * Decompiled with CFR 0.152.
 */
package ecrans;

import base.Ecran;
import base.Outil;
import base.Style;
import ecrans.EcranLancementCourse;
import ecrans.EcranResultats;
import elements.Course;
import elements.Participant;
import elements.Resultats;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import ressources.Images;
import special.SaisieDossard;

public class EcranCourse
extends Ecran
implements ActionListener,
Runnable {
    private static final long serialVersionUID = 1L;
    private final SaisieDossard saisieDossard;
    private final JButton retour;
    private final JButton go;
    private final JButton go2;
    private final JProgressBar arrivees;
    private final Resultats resultats;
    private final Course course;
    private final JPanel barre;
    private final JLabel temps;
    private boolean run;

    public EcranCourse(Course course) {
        super(new BorderLayout());
        this.setImage("fonds/fond.jpg");
        this.setMax(true);
        this.course = course;
        this.resultats = new Resultats(new Course(course.getFichier()));
        this.barre = new JPanel();
        this.barre.setOpaque(false);
        this.barre.setLayout(new BorderLayout());
        JPanel t = new JPanel();
        t.setOpaque(false);
        this.temps = new JLabel(course.getNom());
        t.add(this.temps);
        this.temps.setFont(new Font("Monospaced", 1, 25));
        this.barre.add((Component)t, "Center");
        this.arrivees = new JProgressBar(0, course.getListe().size());
        this.barre.add((Component)this.arrivees, "South");
        this.go = new JButton(Images.getIcone("divers/start.png", 32));
        this.barre.add((Component)this.go, "West");
        this.retour = new JButton("Retour", Images.getIcone("divers/retour.png", 32));
        this.go2 = new JButton("Cliquez pour lancer la course", Images.getIcone("divers/start.png", 100));
        this.add((Component)this.go2, "Center");
        this.saisieDossard = new SaisieDossard(this);
        this.arrivees.setStringPainted(true);
        this.go2.setFont(Style.TITRE);
        this.go.addActionListener(this);
        this.retour.addActionListener(this);
        this.go2.addActionListener(this);
    }

    public Course getCourse() {
        return this.course;
    }

    public boolean arrive(Participant p) {
        if (this.resultats.contient(p)) {
            return false;
        }
        this.resultats.arrive(p);
        this.arrivees.setValue(this.resultats.getListe().size());
        int diff = this.course.getListe().size() - this.resultats.getListe().size();
        this.arrivees.setString("Il reste " + diff + " participant" + (diff > 1 ? "s" : ""));
        if (diff == 0) {
            this.fin();
        }
        return true;
    }

    public void fin() {
        if (!this.run) {
            return;
        }
        int reste = this.course.getListe().size() - this.resultats.getListe().size();
        if (reste <= 0 || Outil.confirmer(String.valueOf(reste) + " participant(s) n'ont pas fini la course. Terminer tout de m\u00eame ?")) {
            for (Participant p : this.course.getListe()) {
                if (this.resultats.getListe().contains(p)) continue;
                this.resultats.arrive(p, "");
            }
            this.run = false;
            this.go.setEnabled(false);
            this.barre.setVisible(false);
            try {
                this.resultats.enregister();
                this.changer(new EcranResultats(new Resultats(this.course.getNom())));
            }
            catch (FileNotFoundException e) {
                Outil.erreur("Impossible d'enregistrer les r\u00e9sultats :\n" + e.getMessage());
                this.changer(new EcranResultats(this.resultats));
            }
        }
    }

    public void commencer() {
        this.retour.setVisible(false);
        this.go.setIcon(Images.getIcone("divers/stop.png", 32));
        this.remove(this.go2);
        this.add(this.getCentre(), "Center");
        this.validate();
        this.repaint();
        if (!this.run) {
            new Thread(this).start();
        }
    }

    public Component getCentre() {
        JPanel p = new JPanel(new BorderLayout());
        p.setOpaque(false);
        p.add((Component)new JScrollPane(new JTable(this.resultats)), "Center");
        p.add((Component)this.saisieDossard, "South");
        this.saisieDossard.setOpaque(false);
        return p;
    }

    public Resultats getResultats() {
        return this.resultats;
    }

    public String getTemps() {
        long t = System.currentTimeMillis() - this.resultats.getDebut();
        int s = (int)(t / 1000L % 60L);
        return String.valueOf(t / 60000L) + ":" + (s < 10 ? "0" : "") + s;
    }

    @Override
    public String getTitre() {
        return this.course.getNom();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.retour) {
            this.changer(EcranLancementCourse.getInstance());
        } else if (e.getSource() == this.go || e.getSource() == this.go2) {
            if (!this.run) {
                this.commencer();
            } else {
                this.fin();
            }
        }
    }

    @Override
    public void run() {
        this.resultats.setDebut(System.currentTimeMillis());
        this.run = true;
        this.saisieDossard.focus();
        while (this.run) {
            this.temps.setText(this.getTemps());
            Outil.wait(1000);
        }
        this.temps.setText("Course termin\u00e9e en " + this.temps.getText());
    }

    @Override
    public JComponent[] getMenu() {
        return new JComponent[]{this.retour, new JSeparator(1), this.barre};
    }
}

