/*
 * Decompiled with CFR 0.152.
 */
package ecrans;

import base.Ecran;
import base.Fenetre;
import base.Outil;
import base.Style;
import composants.ListeGraphique;
import ecrans.EcranListeCourses;
import elements.Course;
import elements.Ensemble;
import elements.EnsembleFiltre;
import elements.Groupe;
import elements.Participant;
import filtres.PanelFiltres;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ressources.Images;
import ressources.ListeGroupes;
import special.RenduGroupe;
import special.RenduParticipantCourse;

public class EcranGestionCourse
extends Ecran
implements ListSelectionListener,
ActionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private final JButton retour;
    private final JButton save;
    private final JButton export;
    private final JButton plusMoins;
    private final JButton addAll;
    private final JComboBox groupes;
    private final Course course;
    private final JTable t;
    private final JPanel p;
    private ListeGraphique<Participant> participants;

    public EcranGestionCourse(Course course) {
        super(new BorderLayout());
        this.setImage("fonds/fond.jpg");
        this.setMax(true);
        this.course = course;
        List<Object> colonnes = new ArrayList();
        for (Groupe grp : ListeGroupes.getInstance().getGroupes()) {
            if (grp.getColonnes().size() <= colonnes.size()) continue;
            colonnes = grp.getColonnes();
        }
        course.setColonnes(new ArrayList<String>(colonnes));
        this.retour = new JButton(Images.getIcone("divers/retour.png", 32));
        this.save = new JButton("Enregistrer", Images.getIcone("divers/save.png", 32));
        this.export = new JButton("Enregistrer sous...", Images.getIcone("divers/exporter.png", 32));
        this.addAll = new JButton("Ajouter tout", Images.getIcone("divers/plusplus.png", 32));
        this.plusMoins = new JButton();
        this.p = new JPanel(new GridLayout());
        this.add((Component)this.p, "Center");
        this.p.setOpaque(false);
        this.t = new JTable();
        this.p.add((Component)new JScrollPane(this.t), "Center");
        this.t.setModel(course);
        this.groupes = new JComboBox(ListeGroupes.getInstance());
        this.groupes.setRenderer(new RenduGroupe());
        this.groupes.addActionListener(this);
        this.retour.addActionListener(this);
        this.save.addActionListener(this);
        this.export.addActionListener(this);
        this.plusMoins.addActionListener(this);
        this.addAll.addActionListener(this);
    }

    @Override
    public void afficher(Fenetre fenetre) {
        super.afficher(fenetre);
        if (this.groupes.getItemCount() > 0) {
            this.groupes.setSelectedIndex(0);
        }
        this.actualise();
    }

    public void retour() {
        if (this.save.isEnabled() && Outil.confirmer("Enregistrer ?")) {
            try {
                this.course.enregister();
            }
            catch (FileNotFoundException e) {
                Outil.erreur(e.getMessage());
            }
        }
        this.getFenetre().changer(EcranListeCourses.getInstance());
    }

    public void setGauche(Component c) {
        if (this.p.getComponentCount() == 2) {
            this.p.remove(0);
        }
        this.p.add(c, 0);
        this.validate();
        this.repaint();
    }

    public void actualise() {
        boolean b;
        boolean bl = b = this.participants != null && this.participants.getSelection() != null;
        if (b) {
            boolean a = this.course.contientSaufDossard(this.participants.getSelection());
            this.plusMoins.setText(a ? "Retirer" : "Ajouter");
            this.plusMoins.setIcon(Images.getIcone("divers/" + (a ? "suppr" : "plus") + ".png", 32));
        }
        this.plusMoins.setEnabled(b);
        this.repaint();
    }

    public void change() {
        Object[] objectArray = this.participants.getSelections();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            Participant p = (Participant)o;
            if (this.course.contientSaufDossard(p)) {
                this.course.supprime(p);
            } else {
                this.course.ajout(p);
            }
            ++n2;
        }
        this.actualise();
    }

    public void ajouterTout() {
        for (Participant p : ((Ensemble)this.participants.getListe().getModel()).getListe()) {
            if (this.course.contientSaufDossard(p)) continue;
            this.course.ajout(p);
        }
        this.actualise();
    }

    @Override
    public String getTitre() {
        return this.course.getNom();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.actualise();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block15: {
            if (e.getSource() == this.groupes) {
                EnsembleFiltre ef = new EnsembleFiltre((Groupe)this.groupes.getSelectedItem());
                this.participants = new ListeGraphique(null, ef.getModele(), this, new RenduParticipantCourse(this.course));
                this.participants.setHaut(new PanelFiltres(ef));
                this.participants.getListe().setSelectionMode(2);
                this.participants.getListe().addKeyListener(this);
                this.participants.getListe().addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() > 1) {
                            EcranGestionCourse.this.change();
                        }
                    }
                });
                this.setGauche(this.participants);
            } else if (e.getSource() == this.retour) {
                this.retour();
            } else if (e.getSource() == this.plusMoins) {
                this.change();
            } else {
                if (e.getSource() == this.export) {
                    try {
                        this.course.exporter();
                    }
                    catch (Exception err) {
                        if (err.getMessage() != null) {
                            Outil.erreur(err.getMessage());
                        }
                        break block15;
                    }
                }
                if (e.getSource() == this.addAll) {
                    this.ajouterTout();
                } else if (e.getSource() == this.save) {
                    try {
                        this.course.enregister();
                    }
                    catch (FileNotFoundException err) {
                        Outil.erreur(err.getMessage());
                    }
                }
            }
        }
    }

    @Override
    public JComponent[] getMenu() {
        JLabel l = new JLabel("    Fichier : ");
        l.setFont(Style.POLICE);
        return new JComponent[]{this.retour, this.save, this.export, this.plusMoins, this.addAll, l, this.groupes};
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
            this.change();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

