/*
 * Decompiled with CFR 0.152.
 */
package ecrans;

import base.Ecran;
import base.Fenetre;
import base.Outil;
import composants.ListeGraphique;
import composants.MenuContextuel;
import divers.FiltreCSV;
import ecrans.EcranAccueil;
import elements.Groupe;
import exceptions.AnnulationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ressources.Images;
import ressources.ListeGroupes;
import special.PanelGroupe;
import special.RenduGroupe;

public class EcranParticipants
extends Ecran
implements ListSelectionListener,
ActionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private static EcranParticipants instance;
    private final JButton nouveau;
    private final JButton importer;
    private final JButton suppr;
    private final JButton retour;
    private final JButton ajoutColonne;
    private final JButton supprColonne;
    private final ListeGraphique<Groupe> groupe;
    private final JSplitPane sp;
    private final JComponent j1;
    private final JComponent j2;
    private final JComponent j3;
    private PanelGroupe p;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EcranParticipants getInstance() {
        Class<EcranParticipants> clazz = EcranParticipants.class;
        synchronized (EcranParticipants.class) {
            if (instance == null) {
                instance = new EcranParticipants();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private EcranParticipants() {
        super(new BorderLayout());
        this.setImage("fonds/fond.jpg");
        this.setMax(true);
        this.sp = new JSplitPane();
        this.add((Component)this.sp, "Center");
        this.retour = new JButton(Images.getIcone("divers/retour.png", 32));
        this.importer = new JButton("Ouvrir", Images.getIcone("divers/ouvrir.png", 32));
        this.nouveau = new JButton("Nouveau", Images.getIcone("divers/new.png", 32));
        this.suppr = new JButton("Supprimer", Images.getIcone("divers/suppr.png", 32));
        this.ajoutColonne = new JButton("Ajouter une colonne", Images.getIcone("divers/plus.png", 32));
        this.supprColonne = new JButton("Supprimer une colonne", Images.getIcone("divers/suppr.png", 32));
        this.groupe = new ListeGraphique(null, ListeGroupes.getInstance(), this, new RenduGroupe());
        this.sp.setLeftComponent(this.groupe);
        this.sp.setOneTouchExpandable(true);
        this.sp.getRightComponent().setVisible(false);
        this.sp.setOpaque(false);
        ((JComponent)this.groupe.getHaut()).setOpaque(false);
        this.suppr.addActionListener(this);
        this.nouveau.addActionListener(this);
        this.importer.addActionListener(this);
        this.retour.addActionListener(this);
        this.ajoutColonne.addActionListener(this);
        this.supprColonne.addActionListener(this);
        this.groupe.getListe().addKeyListener(this);
        MenuContextuel m = new MenuContextuel(this.groupe.getListe());
        m.ajoutMenu((ActionListener)this, "Retour", Images.getIcone("divers/retour.png", 20));
        m.ajoutMenu((ActionListener)this, "Nouveau", Images.getIcone("divers/new.png", 20));
        m.ajoutMenu((ActionListener)this, "Ouvrir", Images.getIcone("divers/ouvrir.png", 20));
        this.j1 = m.ajoutMenu((ActionListener)this, "Supprimer", Images.getIcone("divers/suppr.png", 20));
        this.j2 = m.ajoutMenu((ActionListener)this, "Ajouter une colonne", Images.getIcone("divers/plus.png", 20));
        this.j3 = m.ajoutMenu((ActionListener)this, "Supprimer une colonne", Images.getIcone("divers/suppr.png", 20));
        this.j1.setEnabled(false);
        this.j2.setEnabled(false);
        this.j3.setEnabled(false);
        this.suppr.setEnabled(false);
        this.ajoutColonne.setEnabled(false);
        this.supprColonne.setEnabled(false);
    }

    public void setGroupe(Groupe selection) {
        int x = this.sp.getDividerLocation();
        this.p = new PanelGroupe(selection);
        this.sp.setRightComponent(this.p);
        this.p.getHaut().add(this.ajoutColonne);
        this.p.getHaut().add(this.supprColonne);
        this.sp.setDividerLocation(x < this.getWidth() - 50 ? x : 250);
    }

    @Override
    public String getTitre() {
        return "Gestion des participants";
    }

    @Override
    public void afficher(Fenetre fenetre) {
        super.afficher(fenetre);
        this.actualise();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.setGroupe(this.groupe.getSelection());
            this.actualise();
        }
    }

    public void actualise() {
        boolean b = !this.groupe.getListe().isSelectionEmpty();
        this.j1.setEnabled(b);
        this.j2.setEnabled(b);
        this.j3.setEnabled(b);
        this.suppr.setEnabled(b);
        this.ajoutColonne.setEnabled(b);
        this.supprColonne.setEnabled(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        if (e.getSource() == this.nouveau || "nouveau".equalsIgnoreCase(e.getActionCommand())) {
            EcranParticipants.nouveauGroupe();
        }
        if (e.getSource() == this.importer || "ouvrir".equalsIgnoreCase(e.getActionCommand())) {
            EcranParticipants.chargeGroupe();
        } else if (e.getSource() == this.retour || "retour".equalsIgnoreCase(e.getActionCommand())) {
            this.getFenetre().changer(EcranAccueil.getInstance());
        } else if ((e.getSource() == this.suppr || "supprimer".equalsIgnoreCase(e.getActionCommand())) && Outil.confirmer("Supprimer ce groupe ?")) {
            ListeGroupes.getInstance().supprimeGroupe(this.groupe.getSelection());
            this.sp.getRightComponent().setVisible(false);
            this.groupe.getListe().setSelectedIndex(-1);
        } else if (e.getSource() == this.ajoutColonne || "ajouter une colonne".equalsIgnoreCase(e.getActionCommand())) {
            try {
                this.groupe.getSelection().getColonnes().add(Outil.demander("Nom de la colonne ?"));
                this.p.actualise();
            }
            catch (AnnulationException annulationException) {}
        } else if ((e.getSource() == this.supprColonne || "supprimer une colonne".equalsIgnoreCase(e.getActionCommand())) && (i = JOptionPane.showOptionDialog(null, "Supprimer une colonne", "Choisissez la colonne \u00e0 supprimer", -1, 2, Images.getIcone("divers/suppr.png", 64), this.groupe.getSelection().getColonnes().toArray(), null)) != -1) {
            this.groupe.getSelection().getColonnes().remove(i);
            this.p.actualise();
        }
        this.actualise();
    }

    public static void chargeGroupe() {
        block2: {
            try {
                ListeGroupes.getInstance().ajoutGroupe(Outil.getFichier(0, "Ouvrir", new FiltreCSV())).enregister();
            }
            catch (Exception e) {
                if (e.getMessage() == null) break block2;
                Outil.erreur(e.getMessage());
            }
        }
    }

    public static void nouveauGroupe() {
        block2: {
            try {
                ListeGroupes.getInstance().ajoutGroupe(Outil.demander("Nom du groupe ?")).enregister();
            }
            catch (Exception e) {
                if (e.getMessage() == null) break block2;
                Outil.erreur(e.getMessage());
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.groupe.getSelection() != null && e.getKeyCode() == 127 && Outil.confirmer("Voulez-vous vraiment supprimer ce groupe ?")) {
            ListeGroupes.getInstance().supprimeGroupe(this.groupe.getSelection());
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public JComponent[] getMenu() {
        return new JComponent[]{this.retour, this.nouveau, this.importer, this.suppr};
    }
}

