/*
 * Decompiled with CFR 0.152.
 */
package elements;

import elements.Ensemble;
import elements.Participant;
import exceptions.AnnulationException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Course
extends Ensemble {
    private static final long serialVersionUID = 1L;
    public static final String PATH = "courses/";

    public Course(File f) {
        super(f);
    }

    public Course(String nom) {
        super(nom);
    }

    @Override
    public String getPath() {
        return PATH;
    }

    @Override
    public int getColumnCount() {
        if (this.getColonnes() != null && this.getColonnes().size() > 0) {
            try {
                this.getIndexColonneListe(DOSSARD);
            }
            catch (AnnulationException e) {
                this.getColonnes().add(0, DOSSARD[0]);
            }
        }
        return super.getColumnCount();
    }

    public int getIndexDossard() {
        try {
            return this.getIndexColonne(DOSSARD);
        }
        catch (AnnulationException err) {
            this.getColonnes().add(0, DOSSARD[0]);
            return 0;
        }
    }

    public int getLastDossard() {
        int id = this.getIndexDossard();
        int max = 0;
        for (Participant p : this.getListe()) {
            try {
                max = Math.max(max, Integer.valueOf(p.getChamp(id)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return max;
    }

    public boolean contientSaufDossard(Participant p) {
        int dossard = this.getIndexDossard();
        for (Participant pa : this.getListe()) {
            if (!pa.equivalent(p, dossard)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void ajout(Participant e) {
        int id;
        if ((e = new Participant(new ArrayList<String>(e.getChamps()))).getChamps().size() <= this.getColonnes().size() && ((id = this.getIndexDossard()) < e.getChamps().size() || e.getChamp(id).isEmpty())) {
            try {
                Integer.valueOf(e.getChamp(id));
            }
            catch (Exception err) {
                e.getChamps().add(id, String.valueOf(this.getLastDossard() + 1));
            }
        }
        super.ajout(e);
    }

    @Override
    public void supprime(Participant e) {
        int id = this.getIndexDossard();
        int i = 0;
        while (i < this.getListe().size()) {
            if (this.getListe().get(i).equivalent(e, id)) {
                this.getListe().remove(i);
                --i;
            }
            ++i;
        }
        this.change();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == this.getIndexDossard();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < this.getColonnes().size()) {
            return super.getColumnName(columnIndex);
        }
        return "";
    }

    @Override
    public Participant getParticipantFichier(List<String> champs) {
        return new Participant(champs);
    }
}

