/*
 * Decompiled with CFR 0.152.
 */
package filtres;

import ecrans.Classements;
import elements.EnsembleFiltre;
import filtre.Filtre;
import filtre.FiltreListener;
import filtres.FiltreGraphiqueResult;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class PanelFiltresResult
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final List<Filtre> filtres;
    private final EnsembleFiltre ef;
    private final Classements c;

    public PanelFiltresResult(Classements c, EnsembleFiltre ef) {
        super(new GridLayout(0, 1));
        this.c = c;
        this.addFiltreListener(ef);
        this.setBorder(new TitledBorder("Filtrer"));
        this.setOpaque(false);
        this.ef = ef;
        this.filtres = new ArrayList<Filtre>();
    }

    public void filtrer() {
        this.notifyFiltreListener();
    }

    public void ajoutFiltre(FiltreGraphiqueResult f) {
        this.filtres.add(f);
        this.add(f);
        this.notifyFiltreListener();
    }

    public void retire(FiltreGraphiqueResult f) {
        if (this.getComponentCount() > 1) {
            this.remove(f);
        }
        this.filtres.remove(f);
        this.validate();
        this.repaint();
        if (this.getParent() != null) {
            this.getParent().validate();
            this.getParent().repaint();
        }
        this.notifyFiltreListener();
    }

    public void nouveau() {
        if (this.getComponentCount() < 1 || ((FiltreGraphiqueResult)this.getComponent(this.getComponentCount() - 1)).filtre()) {
            this.ajoutFiltre(new FiltreGraphiqueResult(this, this.ef));
        } else {
            this.filtrer();
        }
    }

    public PanelFiltresResult addFiltreListener(FiltreListener l) {
        this.listenerList.add(FiltreListener.class, l);
        return this;
    }

    public void removeFiltreListener(FiltreListener l) {
        this.listenerList.remove(FiltreListener.class, l);
    }

    public void notifyFiltreListener() {
        FiltreListener[] filtreListenerArray = (FiltreListener[])this.listenerList.getListeners(FiltreListener.class);
        int n = filtreListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            FiltreListener l = filtreListenerArray[n2];
            l.filtrer(this.filtres);
            ++n2;
        }
        this.c.setResultat();
    }

    public List<Filtre> getFiltres() {
        return this.filtres;
    }

    public EnsembleFiltre getEnsembleFiltre() {
        return this.ef;
    }
}

