/*
 * Decompiled with CFR 0.152.
 */
package ressources;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import ressources.RessourcesLoader;

public final class Fichiers {
    public static final int LIMITE = 0x7FFFFF;
    public static final String PATH = "fichiers/";

    private Fichiers() {
    }

    public static String getChemin() {
        return "ressources/fichiers/";
    }

    public static List<String> lire(InputStream in) {
        ArrayList<String> lignes;
        block13: {
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            lignes = new ArrayList<String>();
            try {
                try {
                    String ligne;
                    while ((ligne = r.readLine()) != null) {
                        lignes.add(ligne);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (in == null) break block13;
                    try {
                        r.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        r.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return lignes;
    }

    public static List<String> lire(File fichier) {
        try {
            return Fichiers.lire(new FileInputStream(fichier));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> lire(String nom) {
        return Fichiers.lire(RessourcesLoader.getFichier(PATH + nom, true));
    }

    public static void ecrire(OutputStream out, List<String> contenu) {
        BufferedWriter write = new BufferedWriter(new OutputStreamWriter(out));
        try {
            try {
                for (String l : contenu) {
                    write.write(l);
                    write.newLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    write.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                write.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void ecrire(List<String> contenu, String nom) {
        try {
            Fichiers.ecrire(new FileOutputStream(RessourcesLoader.getFichier(PATH + nom, true)), contenu);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static boolean existe(String nom) {
        return RessourcesLoader.existe(PATH + nom);
    }

    public static String[] getCheminFichiers(String dossier) {
        String[] noms = RessourcesLoader.getCheminFichiers(PATH + dossier);
        int i = 0;
        while (i < noms.length) {
            noms[i] = noms[i].substring(PATH.length());
            ++i;
        }
        return noms;
    }

    public static List<File> getFichiers(String dossier) {
        return RessourcesLoader.getFichiers(PATH + dossier);
    }

    public static File getFichier(String nom, boolean creer) {
        return RessourcesLoader.getFichier(PATH + nom, creer);
    }

    public static long derniereModification(String nom) {
        return RessourcesLoader.getFichier(PATH + nom, true).lastModified();
    }

    public static long tempsDepuisDerniereModification(String nom) {
        return System.currentTimeMillis() - Fichiers.derniereModification(nom);
    }

    public static boolean supprimer(File fichier) {
        return fichier.delete();
    }

    public static boolean supprimer(String ... noms) {
        boolean succes = true;
        String[] stringArray = noms;
        int n = noms.length;
        int n2 = 0;
        while (n2 < n) {
            String nom = stringArray[n2];
            if (!Fichiers.supprimer(nom)) {
                succes = false;
                return false;
            }
            ++n2;
        }
        return succes;
    }

    public static boolean supprimer(String nom) {
        return RessourcesLoader.supprimer(PATH + nom);
    }
}

