/*
 * Decompiled with CFR 0.152.
 */
package ressources;

import elements.Course;
import exceptions.AnnulationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import ressources.Fichiers;

public class ListeCourses
extends DefaultListModel {
    private static final long serialVersionUID = 1L;
    private static ListeCourses instance;
    private final List<Course> courses = new ArrayList<Course>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ListeCourses getInstance() {
        Class<ListeCourses> clazz = ListeCourses.class;
        synchronized (ListeCourses.class) {
            if (instance == null) {
                instance = new ListeCourses();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ListeCourses() {
        for (File f : Fichiers.getFichiers("courses/")) {
            this.courses.add(new Course(f));
        }
    }

    public List<Course> getCourses() {
        return this.courses;
    }

    public Course supprimeCourse(Course c) {
        if (this.courses.remove(c)) {
            c.supprimer();
            this.change();
            return c;
        }
        throw new IllegalArgumentException(c + " n'est pas une course valide");
    }

    public Course ajoutCourse(Course c) {
        this.courses.add(c);
        this.change();
        return c;
    }

    public Course ajoutCourse(String nom) throws AnnulationException {
        String s = "courses/" + nom + ".csv";
        if (Fichiers.existe(s)) {
            throw new AnnulationException("Un groupe porte d\u00e9j\u00e0 le nom " + nom);
        }
        Course c = new Course(nom);
        try {
            c.enregister();
            return this.ajoutCourse(c);
        }
        catch (FileNotFoundException e) {
            throw new AnnulationException(e.getMessage());
        }
    }

    public Course ajoutGroupe(File f) throws AnnulationException {
        if (Fichiers.existe("groupes/" + f.getName())) {
            throw new AnnulationException("Un groupe porte d\u00e9j\u00e0 le nom " + f.getName());
        }
        return this.ajoutCourse(new Course(f));
    }

    protected void change() {
        ListDataListener[] listDataListenerArray = (ListDataListener[])this.getListeners(ListDataListener.class);
        int n = listDataListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ListDataListener l = listDataListenerArray[n2];
            l.contentsChanged(new ListDataEvent(this, 0, this.courses.size() - 1, this.courses.size() - 1));
            ++n2;
        }
    }

    @Override
    public Object getElementAt(int index) {
        return index >= 0 && index < this.courses.size() ? this.courses.get(index) : null;
    }

    @Override
    public int getSize() {
        return this.courses.size();
    }
}

