/*
 * Decompiled with CFR 0.152.
 */
package ressources;

import elements.Groupe;
import exceptions.AnnulationException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import ressources.Fichiers;

public class ListeGroupes
extends DefaultListModel
implements ComboBoxModel {
    private static final long serialVersionUID = 1L;
    private static ListeGroupes instance;
    private final List<Groupe> groupes;
    private int selection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ListeGroupes getInstance() {
        Class<ListeGroupes> clazz = ListeGroupes.class;
        synchronized (ListeGroupes.class) {
            if (instance == null) {
                instance = new ListeGroupes();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ListeGroupes() {
        this.groupes = new ArrayList<Groupe>();
        for (File f : Fichiers.getFichiers("groupes/")) {
            this.groupes.add(new Groupe(f, true));
        }
    }

    private ListeGroupes(List<Groupe> groupes) {
        this.groupes = groupes;
    }

    public List<Groupe> getGroupes() {
        return this.groupes;
    }

    public Groupe supprimeGroupe(Groupe g) {
        if (this.groupes.remove(g)) {
            g.supprimer();
            this.change();
            return g;
        }
        throw new IllegalArgumentException(g + " n'est pas un groupe valide");
    }

    public Groupe ajoutGroupe(Groupe g) {
        this.groupes.add(g);
        this.change();
        return g;
    }

    public Groupe ajoutGroupe(String nom) throws AnnulationException {
        String s = "groupes/" + nom + ".csv";
        if (Fichiers.existe(s)) {
            throw new AnnulationException("Un groupe porte d\u00e9j\u00e0 le nom " + nom);
        }
        Groupe g = this.ajoutGroupe(new Groupe(Fichiers.getFichier(s, true), true));
        g.getColonnes().add("Nom");
        g.getColonnes().add("Pr\u00e9nom");
        g.getColonnes().add("Genre");
        return g;
    }

    public Groupe ajoutGroupe(File f) throws AnnulationException {
        if (Fichiers.existe("groupes/" + f.getName())) {
            throw new AnnulationException("Un groupe porte d\u00e9j\u00e0 le nom " + f.getName());
        }
        return this.ajoutGroupe(new Groupe(f, true));
    }

    public ListeGroupes copier() {
        ArrayList<Groupe> g = new ArrayList<Groupe>();
        for (Groupe grp : this.groupes) {
            g.add(grp);
        }
        return new ListeGroupes(g);
    }

    protected void change() {
        ListDataEvent e = new ListDataEvent(this, 0, 0, this.groupes.size() - 1);
        ListDataListener[] listDataListenerArray = (ListDataListener[])this.getListeners(ListDataListener.class);
        int n = listDataListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ListDataListener l = listDataListenerArray[n2];
            try {
                l.contentsChanged(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    @Override
    public Object getElementAt(int index) {
        return index >= 0 && index < this.groupes.size() ? this.groupes.get(index) : null;
    }

    @Override
    public int getSize() {
        return this.groupes.size();
    }

    @Override
    public Object getSelectedItem() {
        Groupe groupe;
        if (this.groupes.isEmpty()) {
            groupe = null;
        } else if (this.selection < this.groupes.size()) {
            groupe = this.groupes.get(this.selection);
        } else {
            this.selection = 0;
            groupe = this.groupes.get(0);
        }
        return groupe;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selection = this.groupes.indexOf(anItem);
    }
}

