/*
 * Decompiled with CFR 0.152.
 */
package ressources;

import divers.FiltreCSV;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public final class RessourcesLoader {
    public static final String PATH = "ressources/";

    public static File getFichier(String nom, boolean creer) {
        File f = new File(PATH + nom);
        if (!f.exists() && creer) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return f;
    }

    public static boolean existe(String nom) {
        return RessourcesLoader.getFichier(nom, false).exists();
    }

    public static boolean supprimer(String nom) {
        return RessourcesLoader.getFichier(nom, false).delete();
    }

    public static boolean supprimerRecursif(String nom, boolean suppr) {
        File racine = RessourcesLoader.getFichier(nom, false);
        List<File> fichiers = RessourcesLoader.getFichiersDossiersRecurrence(new ArrayList<File>(), racine);
        int i = fichiers.size() - 1;
        while (!fichiers.isEmpty() && i >= 0) {
            if (fichiers.get(i).delete()) {
                fichiers.remove(i);
            }
            if (--i >= 0) continue;
            i = fichiers.size() - 1;
        }
        return suppr ? racine.delete() : true;
    }

    public static boolean supprimer(String ... noms) {
        boolean succes = true;
        String[] stringArray = noms;
        int n = noms.length;
        int n2 = 0;
        while (n2 < n) {
            String nom = stringArray[n2];
            if (!RessourcesLoader.supprimer(nom)) {
                succes = false;
            }
            ++n2;
        }
        return succes;
    }

    public static File getRacine() {
        return new File(PATH);
    }

    public static String[] getCheminFichiers(String dossier) {
        List<File> fichiers = RessourcesLoader.getFichiers(dossier);
        String[] noms = new String[fichiers.size()];
        int i = 0;
        while (i < noms.length) {
            noms[i] = fichiers.get(i).toString().substring(PATH.length());
            ++i;
        }
        return noms;
    }

    public static List<File> getFichiers(String dossier) {
        File[] f = RessourcesLoader.getFichier(dossier, false).listFiles();
        ArrayList<File> lf = new ArrayList<File>();
        FiltreCSV filtre = new FiltreCSV();
        File[] fileArray = f;
        int n = f.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (filtre.accept(file)) {
                lf.add(file);
            }
            ++n2;
        }
        return lf;
    }

    public static List<File> getFichiersDossiersRecurrence(List<File> fichiers, File fichier) {
        if (fichier.isFile()) {
            fichiers.add(fichier);
        } else {
            File[] fileArray = fichier.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                fichiers.add(f);
                if (f.isDirectory()) {
                    RessourcesLoader.getFichiersRecurrence(fichiers, f, new String[0]);
                }
                ++n2;
            }
        }
        return fichiers;
    }

    public static List<File> getFichiersRecurrence(List<File> fichiers, File fichier, String ... extensions) {
        if (fichier.isFile()) {
            if (RessourcesLoader.aExtension(fichier, extensions)) {
                fichiers.add(fichier);
            }
        } else {
            File[] fileArray = fichier.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    RessourcesLoader.getFichiersRecurrence(fichiers, f, extensions);
                } else if (RessourcesLoader.aExtension(f, extensions)) {
                    fichiers.add(f);
                }
                ++n2;
            }
        }
        return fichiers;
    }

    public static List<File> getFichiersRecurrenceExclusion(List<File> fichiers, File fichier, String ... exclure) {
        if (fichier.isFile()) {
            if (!RessourcesLoader.estNom(fichier, exclure)) {
                fichiers.add(fichier);
            }
        } else {
            File[] fileArray = fichier.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (!RessourcesLoader.estNom(f, exclure)) {
                    if (f.isDirectory()) {
                        RessourcesLoader.getFichiersRecurrenceExclusion(fichiers, f, exclure);
                    } else {
                        fichiers.add(f);
                    }
                }
                ++n2;
            }
        }
        return fichiers;
    }

    public static boolean aExtension(File f, String ... extensions) {
        if (extensions.length == 0) {
            return true;
        }
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            if (f.getName().endsWith(String.valueOf('.') + e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean estNom(File f, String ... noms) {
        String[] stringArray = noms;
        int n = noms.length;
        int n2 = 0;
        while (n2 < n) {
            String nom = stringArray[n2];
            if (f.getName().contains(nom)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static BufferedImage getImage(String nom) {
        try {
            return ImageIO.read(RessourcesLoader.getFichier(nom, false));
        }
        catch (Exception e) {
            return new BufferedImage(1, 1, 12);
        }
    }

    public static boolean creerDossier(String nom) {
        return RessourcesLoader.creerDossier(RessourcesLoader.getFichier(nom, false));
    }

    public static boolean creerDossier(File dossier) {
        return dossier.mkdir();
    }
}

