package base;

import io.Images;
import io.Langue;

import java.awt.BorderLayout;
import java.awt.Toolkit;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

import panneaux.Jeu;

public class Fenetre extends JFrame {
	private static final long serialVersionUID = 1L;
	private Jeu jeu;
	private JMenuBar help = new JMenuBar();
	private Images img = new Images();
	
	public Fenetre() {
		super("Save the Trees !");
		setIconImage(img.getArbre());
		setSize(Toolkit.getDefaultToolkit().getScreenSize().width, Toolkit.getDefaultToolkit().getScreenSize().height-30);
		setLocationRelativeTo(null);
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setVisible(true);
		help.add(new JMenu(Langue.getTexte(6)));
		setJMenuBar(help);
		run();
	}
	


	public void run() {
		jeu = new Jeu(this);
		getContentPane().setLayout(new BorderLayout(1, 1));
		getContentPane().add(jeu);
		new Thread(jeu).run();
	}
}
