package constructions;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;

public class Immeuble extends Construction {
	private int hauteur;
	boolean antenne;

	public Immeuble(byte hauteur) {
		this.hauteur = hauteur;
		antenne = Math.random()>0.75;
	}
	
	public void ajoutHauteur(int ajout) {
		hauteur+=ajout;
		if(hauteur>15) hauteur=15;
	}

	public void dessine(Graphics g, Polygon dessous, int taille, double angle) {
		g.setColor(new Color(100,100,100));

		int[] xpoints = {
				dessous.xpoints[3],
				dessous.xpoints[2],
				dessous.xpoints[2],
				dessous.xpoints[3],
				dessous.xpoints[3]
		};
		int[] ypoints = {
				dessous.ypoints[3],
				dessous.ypoints[2],
				dessous.ypoints[2]-hauteur*taille,
				dessous.ypoints[3]-hauteur*taille,
				dessous.ypoints[3]
		};
		Polygon faceAvant = new Polygon(xpoints, ypoints, xpoints.length);
		g.fillPolygon(faceAvant);
		
		g.setColor(new Color(85,85,85));
		int[] xpoints0 = {
				dessous.xpoints[0],
				dessous.xpoints[1],
				dessous.xpoints[2],
				dessous.xpoints[3],
				dessous.xpoints[0]
		};
		int[] ypoints0 = {
				dessous.ypoints[0]-hauteur*taille,
				dessous.ypoints[1]-hauteur*taille,
				dessous.ypoints[2]-hauteur*taille,
				dessous.ypoints[3]-hauteur*taille,
				dessous.ypoints[0]-hauteur*taille
		};
		Polygon dessus = new Polygon(xpoints0, ypoints0, xpoints0.length);
		g.fillPolygon(dessus);

		if(angle>0) {
			g.setColor(new Color(150,150,150));
			int[] xpoints1 = {
					dessous.xpoints[0],
					dessous.xpoints[3],
					dessous.xpoints[3],
					dessous.xpoints[0],
					dessous.xpoints[0]
			};
			int[] ypoints1 = {
					dessous.ypoints[0],
					dessous.ypoints[3],
					dessous.ypoints[3]-hauteur*taille,
					dessous.ypoints[0]-hauteur*taille,
					dessous.ypoints[0]
			};
			Polygon gauche = new Polygon(xpoints1, ypoints1, xpoints0.length);
			g.fillPolygon(gauche);
		}
		else {
			g.setColor(new Color(65,65,65));
			int[] xpoints1 = {
					dessous.xpoints[1],
					dessous.xpoints[2],
					dessous.xpoints[2],
					dessous.xpoints[1],
					dessous.xpoints[1]
			};
			int[] ypoints1 = {
					dessous.ypoints[1],
					dessous.ypoints[2],
					dessous.ypoints[2]-hauteur*taille,
					dessous.ypoints[1]-hauteur*taille,
					dessous.ypoints[1]
			};
			Polygon droite = new Polygon(xpoints1, ypoints1, xpoints0.length);
			g.fillPolygon(droite);
		}
		//porte
		g.setColor(new Color(100,50,0));
		g.fillRect(faceAvant.xpoints[0]+taille/8, faceAvant.ypoints[0]-taille/2, taille/3, taille/2);
		
		//fenetres
		g.setColor(new Color(200,200,255));
		for(int i=1 ; i<=hauteur ; i++) {
			g.fillRect(faceAvant.xpoints[0]+taille/8, faceAvant.ypoints[0]-i*taille+taille/8, taille/4, taille/4);
			g.fillRect(faceAvant.xpoints[0]+taille-taille/3, faceAvant.ypoints[0]-i*taille+taille/8, taille/4, taille/4);
		}
		//antenne
		if(antenne) {
			g.setColor(Color.LIGHT_GRAY);
			g.fillRect(dessus.xpoints[0]+taille/3, dessus.ypoints[0]-taille/5, taille/15, taille/3);
			g.fillOval(dessus.xpoints[0]+taille/8, dessus.ypoints[0]-taille/3, taille/3, taille/3);
			g.setColor(Color.GRAY);
			g.drawRect(dessus.xpoints[0], dessus.ypoints[0]-taille/5, taille/4, taille/20);
		}
	}

}
