package elements;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.ArrayList;

import constructions.Construction;

import mobiles.Mobile;

import objets.Objet;

public class Case {
	private boolean estRoute;
	private ArrayList<Mobile> mobiles;
	private Construction construction;
	private Objet[] objets = new Objet[4];
	private int x, y;
	private float[] altitude = new float[4];
	private Point centre;
	private byte[] teinte = {
			(byte) (50 - (Math.random()*25)), 
			(byte) (40 - (Math.random()*20)), 
			(byte) (25 - (Math.random()*12))};

	public Case(int x, int y, int xmax, int ymax) {
		this.x = x;
		this.y = y;
		centre= new Point(xmax/2,ymax/2);
	}

	public byte getNombreArbres() {
		byte i=0;
		for(Objet o : objets) if(o!=null && o.estArbre()) i++;
		return i;
	}

	public boolean estRoute() {
		return estRoute;
	}

	public void setRoute(boolean estRoute) {
		this.estRoute = estRoute;
	}

	public void setConstruction(Construction c) {
		construction = c;
	}

	public boolean sansConstruction() {
		return construction==null;
	}

	public void agrandirConstruction(int ajout) {
		if(construction!=null) construction.ajoutHauteur(ajout);
	}

	public void effacer() {
		mobiles = new ArrayList<Mobile>(1);
	}

	public void addMobile(Mobile m) {
		if(mobiles==null) mobiles = new ArrayList<Mobile>(1);
		mobiles.add(m);
	}

	public float[] getAltitude() {
		return altitude;
	}

	public void setAltitude(float[] altitude) {
		this.altitude = altitude;
	}

	public void applatir(float niveau, int coin) {
		altitude[coin] = niveau;
	}

	public void incrAltitude(int coin, double altitude) {
		this.altitude[coin] += altitude;
		if(this.altitude[coin]>=8 || this.altitude[coin]<=-4) objets[coin] = null;
	}

	public void dessine(Graphics g, double taille, int dx, int dy, int angle, double angle0) {
		//destruction des arbres
		if(objets!=null && mobiles!=null) {
			for(int i=0 ; i<objets.length ; i++) {
				if(objets[i]!=null) {
					objets[i].reduit(mobiles.size());
					if(objets[i].getTaille()<=0) objets[i]=null;
					break;
				}
			}
		}
		short[] couleur = { 
				(short) (20+15*getAltitudeMoyenne() + teinte[0]),
				(short) (70+15*getAltitudeMoyenne() + teinte[1]),
				(short) (10+15*getAltitudeMoyenne() + teinte[2])
		};

		for(int i=0 ; i<couleur.length ; i++) {
			if(couleur[i]<30) couleur[i] = 30;
			if(couleur[i]>245) couleur[i] = 245;
		}

		Color c = new Color(couleur[0], couleur[1], couleur[2]);
		g.setColor(c);
		Polygon surface = getTuile(taille, dx, dy, angle, angle0);
		g.fillPolygon(surface);

		if(getAltitudeMoyenne()>1.5) dessineTraits(g, surface);

		if(construction!= null) construction.dessine(g, surface, (int) taille, angle);
		try {
			if(mobiles!=null) for(Mobile m : mobiles) m.dessine(g, surface, (int)taille, angle/taille);
		} catch (Exception e) {System.out.println("oups !");}

		for(int i=0 ; i<objets.length ; i++) {
			if(objets[i]!=null) objets[i].dessine(g, surface.xpoints[i], surface.ypoints[i], taille);
		}
	}

	private void dessineTraits(Graphics g, Polygon p) {
		g.setColor(new Color(50,50,50));
		if(altitude[1]<altitude[2]) g.drawLine(p.xpoints[1], p.ypoints[1], p.xpoints[2], p.ypoints[2]);
		if(altitude[0]<altitude[3]) g.drawLine(p.xpoints[0], p.ypoints[0], p.xpoints[3], p.ypoints[3]);
	}

	public float getAltitudeMoyenne() {
		return (altitude[0]+altitude[1]+altitude[2]+altitude[3])/4;
	}

	public Polygon getTuile(double taille, int dx, int dy, int angle, double angle0) {
		return getPolygon(x*taille, y*taille*angle0, taille, dx, dy, angle, angle0);
	}

	private Polygon getPolygon(double x, double y, double taille, int dx, int dy, int angle, double angle0) {
		double d = (y/((double)taille/4))*angle;
		x+=dx+d - (((centre.getY()*taille)/((double)taille/4))*angle)/2;
		y+=dy;
		int[] px = {
				(int) (x-angle), 
				(int) (x+taille-angle), 
				(int) (x+taille+angle), 
				(int) (x+angle), 
				(int) (x-angle)
		};
		int[] py = {
				(int) (y-altitude[0]*taille), 
				(int) (y-altitude[1]*taille), 
				(int) (y+taille/2-altitude[2]*taille), 
				(int) (y+taille/2-altitude[3]*taille), 
				(int) (y-altitude[0]*taille)
		};
		return new Polygon(px, py, 5);
	}

	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}


	public void addObjet(Objet objet, int coin) {
		objets[coin] = objet;
	}

	public void setTeinte(byte[] teinte) {
		this.teinte = teinte;
	}

	public void vider() {
		for(byte b : new byte[] {0,1,2,3}) objets[b] = null;
	}

}
