package elements;

import java.awt.Point;
import java.util.ArrayList;

import mobiles.Homme;
import mobiles.Mobile;

public class Jouer {
	private ArrayList<Mobile> mobiles;
	private Coord debutSpawn;
	private final float chuteMortelle=1.5f;
	
	public Jouer(int nombre, Coord debutSpawn) {
		mobiles = new ArrayList<Mobile>(nombre*2);
		init(nombre, debutSpawn);
	}
	
	public void spawn(int nombre) {
		init(nombre, debutSpawn);
	}

	private void init(int nombre, Coord debutSpawn) {
		this.debutSpawn = debutSpawn;
		for(int i=0 ; i<nombre ; i++) {
			Point spawn = new Point((int) (debutSpawn.getX()+Math.random()*18), (int) (debutSpawn.getY()+Math.random()*18));
			mobiles.add(new Homme(spawn.x, spawn.y, 0, 0));
		}
	}
	
	public ArrayList<Mobile> getMobiles() {
		return mobiles;
	}
	
	public void joue(Case[][] map) {
		for(int i=mobiles.size()-1 ; i>=0 ; i--) {
			Mobile m = mobiles.get(i);
			float altitude = map[m.getX()][m.getY()].getAltitudeMoyenne();
			m.joue(map);
			if(Math.abs(map[m.getX()][m.getY()].getAltitudeMoyenne()-altitude)>chuteMortelle) mobiles.remove(i);
		}
	}
}
