package mobiles;

import elements.Case;

public class Cerveau {
	private final byte po=10;
	private boolean gaucher, fin, remonte;

	public Cerveau() {
		gaucher = Math.random()<0.5;
	}

	public int getProchaineAction(Case[][] map, Mobile perso) {
		if(Math.random()<0.05) gaucher=!gaucher;
		//est sur une case contenant des arbres
		if(map[perso.getX()][perso.getY()].getNombreArbres()>0) return -1;
		//va vers les arbres
		int dir = directionArbre(map, perso);
		if(dir!=-1) return dir;
		//s'eloigner de la ville
		if(!fin) {
			if(gaucher && verifie(map, perso, Mobile.OUEST)) return Mobile.OUEST;
			else {
				if(verifie(map, perso, Mobile.SUD)) return Mobile.SUD;
				else fin = true;
			}
		}
		if(perso.getY()>map[0].length/1.2) remonte = true;
		if(perso.getY()<5) remonte = false;
		
		if(remonte && verifie(map, perso, Mobile.NORD) && Math.random()<0.8) return Mobile.NORD;

		//mouvement aleatoire
		for(int i=0 ; i<10 ; i++) {
			int retour = (int) (Math.random()*4);
			if(verifie(map, perso, retour)) return retour;
		}

		//pas bouger
		return -1;
	}
	
	private boolean peutAller(Case[][] map, Case destination, Mobile perso) {
		float altitude = map[perso.getX()][perso.getY()].getAltitudeMoyenne();
		if(destination.getAltitudeMoyenne()-altitude>1) perso.setVitesse((byte) 1);
		return destination.getAltitudeMoyenne()-altitude<2;
	}

	private int directionArbre(Case[][] map, Mobile perso) {
		for(int i=0 ; i<po ; i++) {
			for(int dir=Mobile.NORD ; dir<=Mobile.OUEST ; dir++) {
				Case test = getCase(dir, i, map, perso.getX(), perso.getY());
				if(test!=null && test.getNombreArbres()>0 && verifie(map, perso, dir)) return dir;
			}
		}
		return -1;
	}

	private Case getCase(int direction, int distance, Case[][] map, int x, int y) {
		switch (direction) {
		case Mobile.NORD:
			if(verifie(map.length, map[0].length, x, y-distance)) return map[x][y-distance];
		case Mobile.SUD:
			if(verifie(map.length, map[0].length, x, y+distance)) return map[x][y+distance];
		case Mobile.EST:
			if(verifie(map.length, map[0].length, x+distance, y)) return map[x+distance][y];
		case Mobile.OUEST:
			if(verifie(map.length, map[0].length, x-distance, y)) return map[x-distance][y];
		}
		return null;
	}

	private boolean verifie(int xmax, int ymax, int x, int y) {
		return x<xmax && y<ymax && x>=0 && y>=0;
	}

	private boolean verifie(Case[][] map, Mobile perso, int direction) {
		switch (direction) {
		case Mobile.NORD:
			return perso.getY()-1>=0 && peutAller(map, map[perso.getX()][perso.getY()-1], perso);
		case Mobile.SUD:
			return perso.getY()+1<map.length && peutAller(map, map[perso.getX()][perso.getY()+1], perso);
		case Mobile.EST:
			return perso.getX()+1<map[0].length && peutAller(map, map[perso.getX()+1][perso.getY()], perso);
		case Mobile.OUEST:
			return perso.getX()-1>=0 && peutAller(map, map[perso.getX()-1][perso.getY()], perso);
		}
		return false;
	}
}
