package mobiles;

import java.awt.Graphics;
import java.awt.Polygon;

import elements.Case;
import elements.Coord;

public abstract class Mobile {
	public static final byte NORD=0, SUD=1, EST=2, OUEST=3;
	private int x, y, posX, posY;
	private final byte mouv=5;
	private byte vitesse;
	private Cerveau cerveau = new Cerveau();

	public abstract void dessine(Graphics g, Polygon dessous, int taille, double d);

	public void memorise(int x, int y, int posX, int posY) {
		this.x=x;
		this.y=y;
		this.posX=posX;
		this.posY=posX;
	}
	
	public void joue(Case[][] map) {
		bouge((byte) cerveau.getProchaineAction(map, this));
	}

	public byte getMouv() {
		return mouv;
	}
	
	public Coord getCoord() {
		return new Coord(x, y);
	}
	
	public void setVitesse(byte vitesse) {
		this.vitesse=vitesse;
	}
	
	public int getX() {
		return x;
	}

	public void setX(int x) {
		this.x = x;
	}

	public int getY() {
		return y;
	}

	public void setY(int y) {
		this.y = y;
	}

	public int getPosX() {
		return posX;
	}

	public void setPosX(int posX) {
		this.posX = posX;
	}

	public int getPosY() {
		return posY;
	}

	public void setPosY(int posY) {
		this.posY = posY;
	}

	public void bouge(byte direction) {
		switch (direction) {
		case NORD:
			posY-=vitesse;
			if(posY<-mouv) {
				y--;
				posY=-mouv+vitesse;
			}
			break;
		case SUD:
			posY+=vitesse;
			if(posY>0) {
				y++;
				posY=-mouv+vitesse;
			}
			break;
		case EST:
			posX+=vitesse;
			if(posX>0) {
				x++;
				posX=-mouv+vitesse;
			}
			break;
		case OUEST:
			posX-=vitesse;
			if(posX<-mouv) {
				x--;
				posX=mouv-vitesse;
			}
			break;
		}
	}
}
